/**
 *
 */
package com.yeejoin.amos.boot.module.ugp.api.constants;

import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;

/**
 * 常量
 */
public class XJConstant {

    public static final String ROOT_PATH = "F:/software/nginx-1.14.2/html/";

    public static final String NGINX_ADDRESS = "172.16.3.77:8081/";

    public static final String DEFAULT_RISKDESC = "默认";
    public static final String JPUSH_USER_KEY ="BANK88";
    public static final String CHECK_TYPE = "CHECK_TYPE";
    public static final String DEPT_WF_MAP_DIC_CODE = "DEPT_WF_MAP";

//附件默认值
    public static final String INSTALL_SUB_FORM="[{\"Symbol_key\":\"B83A18D2-FF89-47D2-BEA2-BAA097E09783\",\"subFormInstall\":\"材质证明文件\",\"info\":\"\",\"type\":\"安装单位\"},{\"Symbol_key\":\"DB0306C1-3520-4BB4-93CE-44DA95AAD408\",\"subFormInstall\":\"焊接工艺评定报告\",\"info\":\"\",\"type\":\"安装单位\"}]";
    public static final String DESIGN_SUB_FORM="[{\"Symbol_key\":\"314C727B-A6A7-40F1-9CFC-C354748657F7\",\"subFormAttachment\":\"设计文件\",\"info\":\"\",\"type\":\"设计单位\"},{\"Symbol_key\":\"5F3B660B-25A2-420C-919E-60F74CE1F36A\",\"subFormAttachment\":\"施工组织设计文件\",\"info\":\"\",\"type\":\"设计单位\"}]";

    // 安装单位
    public static final String INSTALL_SUB_FORM_NEW = "[{\"Symbol_key\":\"B83A18D2-FF89-47D2-BEA2-BAA097E09783\",\"subFormInstall\":\"材质证明文件\",\"info\":\"\",\"type\":\"安装单位\"},{\"Symbol_key\":\"DB0306C1-3520-4BB4-93CE-44DA95AAD408\",\"subFormInstall\":\"焊接工艺评定报告\",\"info\":\"\",\"type\":\"安装单位\"},{\"Symbol_key\":\"DB0306C1-3520-4BB4-93CE-44DA95AAD409\",\"subFormInstall\":\"施工组织设计文件\",\"info\":\"\",\"type\":\"安装单位\"},{\"Symbol_key\":\"DB0306C1-3520-4BB4-93CE-44DA95AAD410\",\"subFormInstall\":\"合同文件\",\"info\":\"\",\"type\":\"安装单位\"}]";
    // 设计单位
    public static final String DESIGN_SUB_FORM_NEW = "[{\"Symbol_key\":\"314C727B-A6A7-40F1-9CFC-C354748657F7\",\"subFormAttachment\":\"设计文件\",\"info\":\"\",\"type\":\"设计单位\"},{\"Symbol_key\":\"5F3B660B-25A2-420C-919E-60F74CE1F36A\",\"subFormAttachment\":\"其他\",\"info\":\"\",\"type\":\"设计单位\"}]";

    // 管材默认附件
    public static final String MATERIAL_FILES = "[{\"name\":\"生产许可证\",\"code\":\"\",\"Symbol_key\":\"2F737BD0-9E53-42E4-8071-4258AAEA8115\",\"info\":[]},{\"name\":\"质量证明书\",\"code\":\"\",\"Symbol_key\":\"5CCD3225-9FAD-4AC8-9E68-B77A01FD7A02\",\"info\":[]},{\"name\":\"监检报告（管子）\",\"code\":\"\",\"Symbol_key\":\"6E0CD003-86A1-4942-9A8C-30FEDD09F535\",\"info\":[]},{\"name\":\"型式试验证书（管件）\",\"code\":\"\",\"Symbol_key\":\"DFF7932A-B68D-4982-80AB-A043D3A7D64A\",\"info\":[]}]";
    //人员org数值
    public static final int ORG_CODE=18;
    public static final int ORG_CODE_USER=12;
    public static final int CODE_USER_SUM = 6;
    public static final String 监检="WzNVBO";

    //流程判断条件
    public static final String condition = "condition";
    public static final String option = "option";

    /** 企业用户注册前缀 */
    public static final String UGP_USER_TEL = "ugp_tel_";

    //审核/审批状态
    public static final String PROCESS_PROJECT_STATE="processProjectState";
    //监管科室
    public static final String INS_DEP = "insDep";
    public static final String INS_DEPID="insDepId";
    public static final String INS_PRESON = "insPerson";
    public static final String INS_PRESONID = "insPersonId";

    /**
     * 构造方法
     */
    private XJConstant() {
        LoggerFactory.getLogger(this.getClass()).debug(XJConstant.CONSTRUCTOR);
    }

    /**
     * 网络服务ip
     */
    public static final String NET_SERVER_HOST = "0.0.0.0";

    /**
     * 请求头key
     */
    public static final String TOKEN_KEY = "token";

    /**
     * 请求头key
     */
    public static final String PRODUCT = "product";

    /**
     * 请求头key
     */
    public static final String APPKEY = "appKey";

    /**
     * 时间格式(yyyy-MM-dd HH:mm:ss)
     */
    public static final SimpleDateFormat SIMPLEDATAFORMAT_YMDHMS = new SimpleDateFormat(
            "yyyy-MM-dd HH:mm:ss");

    /**
     * 构造方法字符串
     */
    public static final String CONSTRUCTOR = "constructor...";

    /**
     * 轮询job最大线程数
     */
    public static final int POLLING_JOB_THREAD_MAX_NUM = 20;

    /**
     * amos线程池数量
     */
    public static final int AMOS_THREAD_NUM = 20;

    /**
     * 设备测试最大线程数
     */
    public static final int TEST_EQUIPMENT_THREAD_MAX_NUM = 5;

    /**
     * 时间格式字符串：yyyy-MM-dd HH:mm:ss
     */
    public static final String DATE_TIME_STR_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    /**
     * bar
     */
    public static final String BAR = "-";

    /**
     * Underline
     */
    public static final String UNDERLINE = "_";

    /**
     * user
     */
    public static final String USER = "user";

    /**
     * token
     */
    public static final String TOKEN = "token";

    /**
     * loginType
     */
    public static final String LOGIN_TYPE = "loginType";

    /**
     * subGraphId
     */
    public static final String SUB_GRAPH_ID = "subGraphId";

    public static final String ADMIN_ID = "1";
    /**
     * 帧报文异常
     */
    public static final String FRAME_EXECPTION = "FRAME";
    /**
     * 性能指标
     */
    public static final String METRIC = "METRIC";
    /**
     * 报文通道
     */
    public static final String CHANNEL = "CHANNEL";

    /**
     * 设备状态(掉线)告警
     */
    public static final String EQUIPMENT_STATUS = "EQUIPMENT_STATUS";

    /**
     * 设备连通性告警告警
     */
    public static final String EQUIPMENT_CONNECTION = "EQUIPMENT_CONNECTION";

    /**
     * 通道注册
     */
    public static final String REGISTER = "REGISTER";

    /**
     * 通道注销
     */
    public static final String UNREGISTER = "UNREGISTER";
    /**
     * 报文正常
     */
    public static final String NORMAL = "NORMAL";
    /**
     * 报文异常
     */
    public static final String UNNORMAL = "UNNORMAL";
    /**
     * 告警socket类型
     */
    public static final String ALARM_SOCKET = "ALARM_SOCKET";
    /**
     * 数据socket类型
     */
    public static final String METRIC_SOCKET = "METRIC_SOCKET";
    /**
     * 数据socket类型
     */
    public static final String MORPHIC_SOCKET = "MORPHIC_SOCKET";

    /**
     * false
     */
    public static final Boolean FAIL_BOOLEAN_VALUE = Boolean.FALSE;

    /**
     * 0
     */
    public static final Integer ZERO_INT_VALUE = Integer.parseInt("0");

    /**
     * -1
     */
    public static final Integer FAIL_INT_VALUE = Integer.parseInt("-1");

    /**
     * -1
     */
    public static final Long FAIL_LONG_VALUE = Long.parseLong("-1");

    /**
     * -1
     */
    public static final Short FAIL_SHORT_VALUE = Short.parseShort("-1");

    /**
     *
     */
    public static final Float FAIL_FLOAT_VALUE = Float.parseFloat("-1");

    /**
     * -1
     */
    public static final Double FAIL_DOUBLE_VALUE = Double.parseDouble("-1");

    /**
     * 空格
     */
    public static final Character FAIL_CHARACTER_VALUE = Character.valueOf(' ');

    /**
     * 失败
     */
    public static final int FAILURE = 0;

    /**
     * 成功
     */
    public static final int SUCCESS = 1;

    /**
     * 在线
     */
    public static final String ONLINE = "在线";

    /**
     * 掉线
     */
    public static final String OFFLINE = "掉线";

    /**
     * 通
     */
    public static final String OPEN = "通";

    /**
     * 不通
     */
    public static final String OFF = "不通";

    /**
     * ip
     */
    public static final String IP = "ip";

    /**
     * #
     */
    public static final String SHARP = "#";


    /**
     * TCP
     */
    public static final String TCP = "TCP";

    public static final String PIE_CHAR = "pieChar";
    public static final String BAR_CHAR = "barChar";
    public static final String HBAR_CHAR = "hbarChar";
    public static final String LINE_CHAR = "lineChar";
    public static final String DOUGHUNT_CHAR = "doughuntChar";
    public static final String ROSE_CHAR = "roseChar";
    public static final String AREA_CHAR = "areaChar";
    public static final String DIMENSION = "dimension";
    public static final String MEASURE = "measure";

    /**
     * xunjian
     */
    public static final String TABLE_USERS = "Users";
    public static final String EDIT_PWD = "editPassword";
    public static final String EDIT_NOT_PWD = "editUsersInfo";
    public static final String SAVE_USERS = "saveTableById";
    public static final String SAVE_COM_USER = "saveComUserInfo";
    public static final String EDIT_COM_USER = "editComUserInfo";
    public static final String TABLE_CHECK = "Check";
    public static final String TABLE_COM_USER = "companyUser";
    public static final int FINISH_YES = 2;
    public static final int FINISH_ING = 1;
    public static final int FINISH_NO = 0;
    public static final String SAVE_DEPART = "saveDepartMent";
    public static final String EDIT_DEPART = "editsDepartMent";
    public static final String TABLE_DEPART = "Group";
    public static final String TABLE_ERROR = "Error";//隐患表
    public static final String SAVE_ERROR = "saveErrorByID";//更新隐患表
    public static final int XJ_ADMIN_ROLE = 9;//巡检管理员角色ID
    public static final int XJ_USER_ROLE = 0;//巡检普通用户角色ID

    public static final int TASK_STATUS_TIMEOUT = 3;//已超时
    public static final int TASK_STATUS_FINISH = 2;//已结束
    public static final int TASK_STATUS_DEAL = 1;//进行中
    public static final int TASK_STATUS_NO_START = 0;//未开始
    public static final String PLAN_TASK_DET_FINISH_NO = "0";//任务明细状态：未完成
    public static final String PLAN_TASK_DET_FINISH_YES = "1";//任务明细状态：完成
    public static final String PLAN_TASK_DET_FINISH_OUT = "2";//任务明细状态：超时漏检

    public static final String USER_DATA_ADMIN = "全部可见"; //用户数据可见范围
    public static final String USER_DATA_DEPART = "部门可见"; //用户数据可见范围
    public static final String USER_DATA_PERSON = "个人可见"; //用户数据可见范围
    public static final String USER_ROLE_SUPERADMIN = "1"; //权限id-超级管理员
    public static final String USER_ROLE_ADMIN = "2"; //权限id-管理员
    public static final String USER_ROLE_DEPART = "3"; //权限id-部门管理
    public static final String USER_ROLE_PERSON = "4"; //权限id-普通用户

    public static final String ROLE_NAME_SUPERADMIN = "SUPERADMIN"; //数据权限-超级管理员
    public static final String ROLE_NAME_ADMIN = "ADMIN"; //数据权限-超级管理员
    public static final String ROLE_NAME_DEPTADMIN = "DEPTADMIN"; //数据权限-部门
    public static final String ROLE_NAME_PERSON = "PERSONAL"; //数据权限-个人
    public static final String ADMIN_FLAG = "2"; //权限标记
    public static final String DEPART_FLAG = "1"; //权限标记
    public static final String PERSON_FLAG = "0";//权限标记
    public static final String ADMIN_FLAG_NO = "0"; //标记 0-无关
    public static final String ADMIN_FLAG_UP = "1"; //1-上级admin
    public static final String ADMIN_FLAG_THIS = "2"; //2-本级admin

    public static final String UNCLASSIFIED = "Unclassifed"; //巡检点未分类

    public static final String ADMIN_ORG_CODE = "2";

    public static final String CHECK_CHANGE_NO = "0";//是否记为合格：否
    public static final String CHECK_CHANGE_YES = "1";//是否记为合格：是

    public static final String SCHED_FLAG = "99";//自动任务标记
    public static final String REGEN_FLAG = "98";//重做任务标记

    public static final String FIX_DATE_NO = "0";//不固定日期（区间）
    public static final String FIX_DATE_YES = "1";//固定日期
    //计划类型
    public static final String PLAN_TYPE_DAY = "1";//日计划
    public static final String PLAN_TYPE_WEEK = "2";//周计划
    public static final String PLAN_TYPE_MONTH = "3";//月计划
    public static final String PLAN_TYPE_YEAR = "4";//年计划
    //月类型
    public static final String MONTH_TYPE_DAY = "1";//第几天
    public static final String MONTH_TYPE_AT = "2";//在第几周的第几天

    public static final String INTERVAL_UNIT_HOUR = "1";//执行间隔小时
    public static final String INTERVAL_UNIT_MINUTE = "2";//执行间隔分钟
    public static final String INTERVAL_UNIT_SECOND = "3";//执行间隔秒

    public static final String ZERO_TIME = "00:00:00";//time


    public static final String PLAN_STATUS_START = "0";//计划状态：正常
    public static final String PLAN_STATUS_STOP = "1";//计划状态：已停用

    public static final int PLAN_FIRST_STATUS_YES = 0;//计划：初始状态
    public static final int PLAN_FIRST_STATUS_NO = 1;//计划：非初始状态

    public static final String UPD_PLAN_GEN_DATE = "1";//更新plan表日期
    public static final String UPD_PLAN_STATUS = "2";//更新plan表next_gen_status


    public static final int DAY_RATE_ONE = 0;//0-1次
    public static final int DAY_RATE_MANY = 1;//1-多次

    public static final int IS_DETETE_NO = 0;//未删除
    public static final int IS_DETETE_YES = 1;//删除


    public static final String UPLOAD_ROOT_PATH = "upload";
    public static final String INPUT_ITEM_TEXT = "文本";
    public static final String INPUT_ITEM_NUMBER = "数字";
    public static final String INPUT_ITEM_SELECT = "选择";

    public static final String CHECK_TYPE_ALWAYS_OK = "始终合格";
    public static final String CHECK_TYPE_ALWAYS_NO = "始终不合格";
    public static final String CHECK_TYPE_NO_CONTEXT_OK = "无内容合格";
    public static final String CHECK_TYPE_CONTEXT_OK = "有内容合格";

    public static final String OK = "合格";
    public static final String NO = "不合格";
    public static final String YES = "是";
    public static final String NOT = "否";

    public static final String INPUT_ITEM_OK_SCORE = "OkScore";
    public static final String INPUT_ITEM_NOT_SCORE = "NoScore";

    public static final String POINT_OK_SCORE = "1";
    public static final String POINT_NOT_SCORE = "0";
    /**
     * 任务是否发送消息状态
     */
    public static final String TASK_WARN = "是";
    public static final String TASK_NOT_WARN = "否";

    /**
     * 系统定时任务类型
     */
    public static final String STATUS_MONITOR_START = "statusMonitorStart"; //状态监控是否开始

    public static final String STATUS_MONITOR_END = "statusMonitorEnd"; //状态监控是否结束

    public static final String PLAN_TASK_WARN_MSG_PUSH = "planTaskWarnMsgPush"; //计划即将开始消息提醒推送

    public static final String PLAN_TASK_BEGIN_MSG_PUSH = "planTaskBeginMsgPush"; //计划已经开始消息提醒推送

    public static final String PLAN_TASK_END_MSG_PUSH = "planTaskEndMsgPush"; //计划已经开始消息提醒推送

    public static final String MESSAGE_PUSH = "messagePush"; //消息推送

    public static final int IS_SENT = 1; //已发送
    public static final int NOT_SENT = 0; //未发送

    public static final String IS_FIXED_YES = "1"; //固定点

}
