package com.yeejoin.amos.boot.module.jcs.biz.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.feign.EquipFeignClient;
import com.yeejoin.amos.boot.module.jcs.api.dto.FusionDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.VoiceRecordFileDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.VoiceRecordFile;
import com.yeejoin.amos.boot.module.jcs.api.entity.VoiceRecordLog;
import com.yeejoin.amos.boot.module.jcs.api.enums.EmployeeEnum;
import com.yeejoin.amos.boot.module.jcs.api.enums.PropertyEnum;
import com.yeejoin.amos.boot.module.jcs.api.mapper.VoiceRecordFileMapper;
import com.yeejoin.amos.boot.module.jcs.api.service.IVoiceRecordFileService;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 通话记录附件服务实现类
 *
 * @author system_generator
 * @date 2021-08-03
 */
@Service
public class VoiceRecordFileServiceImpl extends BaseService<VoiceRecordFileDto, VoiceRecordFile, VoiceRecordFileMapper> implements IVoiceRecordFileService {

    private final String SINGLE_PAWN = "FUSION_TERMINAL_SINGLE_PAWN";

    @Autowired
    private VoiceRecordFileServiceImpl voiceRecordFileServiceImpl;

    private final Logger logger = LogManager.getLogger(VoiceRecordFileServiceImpl.class);

    @Autowired
    AlertCalledServiceImpl iAlertCalledService;

    @Autowired
    FusionServiceImpl fusionService;

    private volatile JSONArray ctiInfos;

    @Autowired
    EmqKeeper emqKeeper;

    @Autowired
    VoiceRecordLogServiceImpl iVoiceRecordLogServiceImpl;

    @Autowired
    EquipFeignClient equipFeignClient;

    /**
     * 分页查询
     */
    public Page<VoiceRecordFileDto> queryForVoiceRecordFilePage(Page<VoiceRecordFileDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<VoiceRecordFileDto> queryForVoiceRecordFileList() {
        return this.queryForList("", false);
    }

    @Override
    public void publishRecord(final VoiceRecordFileDto model) {
        Map<String, String> dMap = fusionService.getCallRecordByNumber(model.getCaller(), model.getCalled());
        // 保存到日志表中
        VoiceRecordLog log = new VoiceRecordLog();
        VoiceRecordFile voiceRecordFile = new VoiceRecordFile();
        BeanUtils.copyProperties(model, voiceRecordFile);
        log.setAlertId(model.getAlertId());
        log.setConnectId(dMap.get("cid"));
        log.setIsDeal(false);
        log.setDealTimes(0);
        save(voiceRecordFile);
        iVoiceRecordLogServiceImpl.save(log);
    }

    @Override
    public Page<VoiceRecordFileDto> queryRecordListByQueryDto(Page<VoiceRecordFileDto> page, String telStartTimeStr, String telEndTimeStr, String fileType, String caller, String called, String sortParam, String sortRule) {
        Page<List<VoiceRecordFileDto>> list = baseMapper.queryRecordListByQueryDto(page,
                telStartTimeStr, telEndTimeStr, fileType, caller,
                called, sortParam, sortRule);
        Page<VoiceRecordFileDto> page1 = new Page<>();
        List<VoiceRecordFileDto> resultDtoList = JSONArray.parseArray(JSONArray.toJSONString(list.getRecords()), VoiceRecordFileDto.class);
        page1.setCurrent(page.getCurrent());
        page1.setSize(page.getSize());
        page1.setTotal(list.getTotal());
        page1.setRecords(resultDtoList);
        return page1;
    }

    @Override
    public VoiceRecordFileDto getRecordById(Long sequenceNbr) {
        VoiceRecordFileDto record = baseMapper.getRecordById(sequenceNbr);
        return record;
    }

    @Override
    public List<VoiceRecordFileDto> selectExportData(String exportId) {
        List<String> ids = null;
        if (StringUtils.isNotEmpty(exportId)) {
            String[] idStr = exportId.split(",");
            ids = Arrays.asList(idStr);
        }
        return baseMapper.selectExportData(ids);
    }

    @Override
    public List<FusionDto> getCarList(Boolean hasFusion) {
        List<FusionDto> fusionDtos = new ArrayList<>();
        List carList = equipFeignClient.getCarFusionList().getResult();
        List<String> employeeIDs = getAllOnlineUser();

        if (!ValidationUtil.isEmpty(carList)) {
            carList.forEach(x -> {
                FusionDto fusionDto = new FusionDto();
                Map map = (Map) x;
                fusionDto.setName(String.valueOf(map.get("name")));
                fusionDto.setCarNum(String.valueOf(map.get("carNum")));
                buildFusionDtoAndId(fusionDto, employeeIDs, hasFusion, map);
                fusionDtos.add(fusionDto);
            });
        }

        return fusionDtos;
    }

    @Override
    public List<FusionDto> getSinglePawnList(Boolean hasFusion) {
        List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(SINGLE_PAWN).getResult();
        List<FusionDto> fusionDtos = new ArrayList<>();
        List<String> employeeIDs = getAllOnlineUser();

        result.forEach(model -> {
            FusionDto fusionDto = new FusionDto();
            String employeeID = model.getDictDataKey();
            fusionDto.setId(employeeID);
            fusionDto.setName(model.getDictDataValue());
            fusionDtos.add(buildFusionDto(fusionDto, employeeIDs, hasFusion));
        });

        return fusionDtos;
    }

    /**
     * 获取在线用户的employeeID集合
     *
     * @return
     */
    private List<String> getAllOnlineUser() {
        JSONObject jsonObject = fusionService.getAllOnlineUser();
        List<String> employeeIDs = new ArrayList<>();
        if (!ValidationUtil.isEmpty(jsonObject)) {
            JSONArray onlines = jsonObject.getJSONArray("Onlines");
            onlines.forEach(x -> {
                Map<String, String> obj = (Map) x;
                employeeIDs.add(obj.get("employeeID"));
            });
        }
        return employeeIDs;
    }

    private FusionDto buildFusionDtoAndId(FusionDto fusionDto, List<String> employeeIDs, Boolean hasFusion, Map map){
        List carPropertyList = (List) map.get("carPropertyList");
        carPropertyList.forEach(carProperty -> {
            Map carPropertyMap = (Map) carProperty;
            Object nameKey = carPropertyMap.get("nameKey");
            if (hasFusion && PropertyEnum.GIS.getValue().equals(nameKey)){
                fusionDto.setId(String.valueOf(carPropertyMap.get("value")));
            } else if (!hasFusion && PropertyEnum.VIDEO.getValue().equals(nameKey)) {
                fusionDto.setId(String.valueOf(carPropertyMap.get("value")));
            }
        });
        buildFusionDto(fusionDto, employeeIDs, hasFusion);
        return fusionDto;
    }

    private FusionDto buildFusionDto(FusionDto fusionDto, List<String> employeeIDs, Boolean hasFusion) {
        if (hasFusion) {
            Map<String, String> dMap = fusionService.getGISByEmployeeID(fusionDto.getId());
            fusionDto.setLatitude(dMap.get("latitude"));
            fusionDto.setLongitude(dMap.get("longitude"));
            fusionDto.setState(employeeIDs.contains(fusionDto.getId()) ? EmployeeEnum.在线.getValue() : EmployeeEnum.离线.getValue());
        }
        return fusionDto;
    }
}