package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.ConstructionInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.ConstructionInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.ConstructionInfo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 特种设备基本信息-施工信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class ConstructionInfoService extends AppBaseService<ConstructionInfoModel, ConstructionInfo, ConstructionInfoMapper> {


    /**
     *
     * 新增施工信息
     *
     * @param model 施工信息实体类集合
     * @return 成功返回“OK”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveConstructionInfo(List<ConstructionInfo> model) {
        //TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("施工信息为空.");
        }
        for (ConstructionInfo models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());
        }
        this.saveBatch(model);
        return "OK";
    }


    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(ConstructionInfo models) {
//        if(ValidationUtil.isEmpty(models.getSequenceCode())) {
//            throw new BadRequest("设备唯一标识码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSuperviseCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"监管系统唯一编码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUscUnitCreditCode())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"施工单位统一社会信用代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUscUnitName())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"施工单位名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getConstructionType())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"施工类型(安装、改造、移装)不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUscInformId())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"安装/改造/移装告知ID不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUscDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"施工时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("设备标识码为："+models.getSequenceCode()+"的设备，"+"同步状态不能为空！");
//        }
//    }
}
