package com.yeejoin.amos.boot.module.jxiop.biz.scheduled;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.EquipDicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipDic;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.EquipDivergenceAlarmEvent;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.MonitorFanIndicatorImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.tdmapper.EquipDivergenceAlarmEventMapper;

@Service
@EnableScheduling
public class EquipWarnSchedule {

	@Autowired
	private MonitorFanIndicatorImpl monitorFanIndicatorImpl;

	@Autowired
	private StationBasicMapper stationBasicMapper;

	@Autowired
	private EquipDivergenceAlarmEventMapper equipDivergenceAlarmEventMapper;

	@Autowired
	private EquipDicMapper equipDicMapper;

	@Scheduled(cron = "${equip.warn.cron}")
	//@PostConstruct
	private void doEquipDivergencWarn() {
		List<EquipDivergenceAlarmEvent> eventList = new ArrayList<EquipDivergenceAlarmEvent>();

		EquipDic equipDic = equipDicMapper
				.selectOne(new LambdaQueryWrapper<EquipDic>().eq(EquipDic::getDicKey, "LSVGJYZ"));

		LambdaQueryWrapper<StationBasic> wrapper = new LambdaQueryWrapper<>();
		wrapper.like(StationBasic::getStationType, "GFDZ");
		List<StationBasic> stationList = stationBasicMapper.selectList(wrapper);
		for (StationBasic stationBasic : stationList) {
			ArrayList<Map<String, Object>> resultList = monitorFanIndicatorImpl.getLSV(stationBasic.getFanGatewayId());
			if (!resultList.isEmpty()) {
				for (Map<String, Object> map : resultList) {
					Double lsv = Double.valueOf( String.valueOf(map.get("lsv")));
					if (lsv > equipDic.getDicValue()) {
						String zz = (String) map.get("zz");
						String nbq = (String) map.get("nbq");
						String hlx = (String) map.get("hlx");
						EquipDivergenceAlarmEvent equipDivergenceAlarmEvent = new EquipDivergenceAlarmEvent();
						equipDivergenceAlarmEvent.setEquipName(zz + "/" + nbq + "/" + hlx);
						equipDivergenceAlarmEvent.setGatewayId(stationBasic.getFanGatewayId());
						equipDivergenceAlarmEvent.setValue(lsv.toString());
						equipDivergenceAlarmEvent.setAlarmGroupName("离散率告警");
						equipDivergenceAlarmEvent.setEventDesc("离散率超过告警阈值");
						eventList.add(equipDivergenceAlarmEvent);
					}
				}
			}
		}
		equipDivergenceAlarmEventMapper.save(eventList);
	}
}
