package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum PersonAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    NAME("姓名", "name", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    NEWPOST("人员类型", "newPost", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryRYLX", null, null, FieldType.Keyword),
    SUBPOST("子类型", "subPost", null, "/statistics/comprehensiveStatisticalAnalysis/select/querySubRYLX?type={type}", null, "newPost", FieldType.Keyword),
    CERT_NO("有无资质", "certNo", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryCertNo", null, null, FieldType.Keyword),
    EXPIRY_DATE("资质状态", "expiryDate", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryExpiryDate", null, null, FieldType.Date),
    CERT_TYPE("证书类型", "certType", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryCertType", null, null, FieldType.Keyword),
    PERMISSION_LEVEL("证书级别", "permissionLevel", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryPermissionLevel", null, null, FieldType.Keyword),
    JOB_ITEM("作业项目", "jobItem", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryTypeZYXM?type={type}", null, "certType", FieldType.Keyword),
    PERMISSION_ITEM("项目", "permissionItem", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryLevelZYXM?type={type}", null, "permissionLevel", FieldType.Keyword),
    ISSUE_DATE("发证日期", "issueDate", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    EDUCATION("学历", "education", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryDicData?type={type}", "QYRYXL", null, FieldType.Keyword),
    ADDRESS("住址", "address", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    UNITCODE("所属单位", "unitName", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Keyword),
    EQUIP_TYPE("设备类型", "equipType", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryEquipList", null, null, FieldType.Keyword),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;
    private String dataKey;
    private String argKey;
    private FieldType esType;

    public static JSONArray getAll() {
        JSONArray jsonArray = new JSONArray();
        for (PersonAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("dataKey", item.dataKey);
            jsonObject.put("argKey", item.argKey);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if (TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)) {
                jsonObject.put("type", "inputNumber");
            } else if (TechnicalParameter.ParamType.STRING.equals(item.paramType)) {
                jsonObject.put("type", "input");
            } else if (TechnicalParameter.ParamType.DATE.equals(item.paramType)) {
                jsonObject.put("type", "date");
            } else {
                jsonObject.put("type", "select");
            }
            jsonObject.put("conditions", ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }

    public static Map<String, FieldType> getEsType = new HashMap<>();

    static {
        for (PersonAdvanceSearchEnum e : PersonAdvanceSearchEnum.values()) {
            getEsType.put(e.code, e.esType);
        }
    }
}
