package com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Service
@RequiredArgsConstructor
public class FormatService {


    private final ApplicationContext context;

    private final CbDataDictTypeHandler dataDictTypeHandler;

    private final PlatformDictTypeHandler platformDictTypeHandler;

    private final Map<String, TypeHandler<String>> handlerCache = new ConcurrentHashMap<>();

    @Value("${type-handler.default:defaultTypeHandler}")
    private String defaultHandlerName;

    public String format(FieldDisplayDefine displayDefine, String value) {
        // 字典优先
        // 1.1兼容之前的业务字典，有字典配置时默认是业务字典
        if(StringUtils.isNotEmpty(displayDefine.dictCode()) && (displayDefine.dictType().equals(FieldDisplayDefine.DictType.no) || displayDefine.dictType().equals(FieldDisplayDefine.DictType.cb))){
            return dataDictTypeHandler.handle(displayDefine.dictCode(), value);
        }
        // 1.2平台字典
        if(StringUtils.isNotEmpty(displayDefine.dictCode()) && displayDefine.dictType().equals(FieldDisplayDefine.DictType.platform)){
            return platformDictTypeHandler.handle(displayDefine.dictCode(), value);
        }

        // 其次是自定义的处理器
        try {
            TypeHandler<String> handler = handlerCache.computeIfAbsent(displayDefine.typeHandler(),
                    k -> context.getBean(k, TypeHandler.class)
            );
            return handler.handle(value);
        } catch (NoSuchBeanDefinitionException e) {
            TypeHandler<String> defaultHandler = context.getBean(defaultHandlerName, TypeHandler.class);
            handlerCache.put(displayDefine.typeHandler(), defaultHandler); // 缓存回退处理器的关联
            return defaultHandler.handle(value);
        }
    }
}
