package com.yeejoin.amos.boot.module.jyjc.biz.result.processor;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Sets;
import com.yeejoin.amos.boot.biz.common.utils.SnowflakeIdUtil;
import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.jg.api.common.PipLenCalUtils;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.BizEmqPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.result.factory.support.SupportableResultDataProcessor;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.CommonServiceImpl;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.JyjcInspectionResultServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgInspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgTechParamsPipeline;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgInspectionDetectionInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgProjectContraptionMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgTechParamsPipelineMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.UseInfoMapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.*;

@Component
@RequiredArgsConstructor
public class BatchEquipResultDataProcessor implements SupportableResultDataProcessor {

    private final IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    private final ObjectMapper objectMapper;

    private final IdxBizJgTechParamsPipelineMapper techParamPipelineMapper;

    private final IdxBizJgInspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    private final BizEmqPublisher bizEmqPublisher;

    private final CommonServiceImpl commonService;

    private final SnowflakeIdUtil sequence;

    private final UseInfoMapper useInfoMapper;

    private final JyjcInspectionResultServiceImpl inspectionResultService;

    private final IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;

    private static final Set<String> SUPPORTED_TYPES = Sets.newHashSet(EquipmentClassifityEnum.YLGD.getCode());

    @Override
    public boolean support(String equList) {
        return SUPPORTED_TYPES.contains(equList);
    }

    @Override
    public void process(JyjcInspectionResult jyjcInspectionResult) {
        Set<String> records = new HashSet<>();
        JyjcInspectionResultParam param = iJyjcInspectionResultParamService.getOneParamByResultSeq(jyjcInspectionResult.getSequenceNbr());
        if (!ObjectUtils.isEmpty(param.getParamJson())) {
            JSONObject paramObj = JSON.parseObject(param.getParamJson());
            try {
                List<Map<String, Object>> equips = objectMapper.readValue(
                        objectMapper.writeValueAsString(paramObj.get("equip")),
                        new TypeReference<ArrayList<Map<String, Object>>>() {
                        }
                );
                equips.forEach(e -> {
                    String record = String.valueOf(e.get("equipId"));
                    records.add(record);
                    // 1.更新管道的技术参数
                    updateTechParams(e, record);
                    // 2.检验信息更新或者插入
                    IdxBizJgInspectionDetectionInfo info = new IdxBizJgInspectionDetectionInfo();
                    LambdaQueryWrapper<IdxBizJgInspectionDetectionInfo> wrapper = new LambdaQueryWrapper<>();
                    wrapper.eq(IdxBizJgInspectionDetectionInfo::getResultSeq, jyjcInspectionResult.getSequenceNbr());
                    wrapper.eq(IdxBizJgInspectionDetectionInfo::getRecord, record);
                    List<IdxBizJgInspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
                    JyjcInspectionResultAttachment jybgFile = inspectionResultService.getReportAttachment(jyjcInspectionResult.getSequenceNbr());
                    if (CollectionUtils.isEmpty(list)) {
                        // 无则插入
                        commonService.buildInspectInfo(jyjcInspectionResult, info, jybgFile, record);
                        info.setSequenceNbr(sequence.nextId() + "");
                        inspectionDetectionInfoMapper.insert(info);
                        // 对方不查询库 所以无事务操作
                        bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
                    } else {
                        // 已经维护过则更新
                        info = list.get(0);
                        commonService.buildInspectInfo(jyjcInspectionResult, info, jybgFile, record);
                        inspectionDetectionInfoMapper.updateById(info);
                        // 对方不查询库 所以无事务操作
                        bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
                    }
                    // 3.更新使用信息表，最新检验信息
                    useInfoMapper.updateByRecord(record, jyjcInspectionResult.getNextInspectionDate(), jyjcInspectionResult.getInspectionType(), jyjcInspectionResult.getApplicationNo());
                    // 4.更新es下次检验日期
                    commonService.updateEquipNextInspectDate(jyjcInspectionResult, record);
                });
            } catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            // 5.新计算管道长度
            inspectionResultService.calAndWriteTotalPipelineLength(jyjcInspectionResult.getEquipUnicode());
            // 6.发送数据刷新消息
            inspectionResultService.sendDataRefreshMsg(records);
        }
    }

    private void updateTechParams(Map<String, Object> e, String record) {
        this.doUpdatePipelineTechParams(e, record, techParamPipelineMapper);
    }

    private void doUpdatePipelineTechParams(Map<String, Object> e, String record, IdxBizJgTechParamsPipelineMapper techParamPipelineMapper) {
        IdxBizJgTechParamsPipeline techParamPipeline = new IdxBizJgTechParamsPipeline();
        BeanUtil.copyProperties(e, techParamPipeline, true);
        LambdaUpdateWrapper<IdxBizJgTechParamsPipeline> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(IdxBizJgTechParamsPipeline::getRecord, record);
        updateWrapper.set(IdxBizJgTechParamsPipeline::getNominalDiameter, techParamPipeline.getNominalDiameter());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWallThickness, techParamPipeline.getWallThickness());
        // TODO 此处注意由于pipeLength字段在检验对接时使用，未不修改对接文档字段，只修改数据类型由之前的浮点型调整为文本型，减少对接文档的调整，故如此
        updateWrapper.set(IdxBizJgTechParamsPipeline::getPipeLengthText, techParamPipeline.getPipeLength());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getPipeLength, PipLenCalUtils.cal(techParamPipeline.getPipeLength()));
        updateWrapper.set(IdxBizJgTechParamsPipeline::getPressure, techParamPipeline.getPressure());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getTemperature, techParamPipeline.getTemperature());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getMedium, techParamPipeline.getMedium());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWorkMedium, techParamPipeline.getWorkMedium());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWorkPressure, techParamPipeline.getWorkPressure());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getWorkTemperature, techParamPipeline.getWorkTemperature());
        updateWrapper.set(IdxBizJgTechParamsPipeline::getRemarks, techParamPipeline.getRemarks());
        techParamPipelineMapper.update(null, updateWrapper);
    }

}
