package com.yeejoin.amos.boot.module.statistics.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

@Getter
@AllArgsConstructor
public enum AnomalyTypeEnum {

    NORMAL("正常", "0"),
    ABNORMAL("异常", "1");

    private String name;
    private String code;

    public static Map<String,String> getName=new HashMap<>();
    public static Map<String,String> getCode=new HashMap<>();

    static {
        for (AnomalyTypeEnum e : AnomalyTypeEnum.values()) {
            getCode.put(e.name, e.code);
            getName.put(e.code, e.name);
        }
    }
    public static AnomalyTypeEnum getEnumByStatus(String code) {
        for (AnomalyTypeEnum c : AnomalyTypeEnum.values()) {
            if (c.getCode().equals(code)){
                return c;
            }
        }
        return null;
    }
}
