package com.yeejoin.amos.boot.module.ccs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 设备报警信息表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("asf_fire_equipment_alarm")
public class FireEquipmentAlarm extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 站点名称
     */
    @TableField("station_name")
    private String stationName;

    /**
     * 站点编码
     */
    @TableField("station_code")
    private String stationCode;

    /**
     *
     */
    @TableField("fire_equipment_name")
    private String fireEquipmentName;

    /**
     * 消防设备id
     */
    @TableField("fire_equipment_mrid")
    private String fireEquipmentMrid;

    /**
     * 设备编码
     */
    @TableField("iot_code")
    private String iotCode;

    /**
     * 指标名称
     */
    @TableField("fire_equipment_index_name")
    private String fireEquipmentIndexName;

    /**
     * 指标编码
     */
    @TableField("fire_equipment_index_key")
    private String fireEquipmentIndexKey;

    /**
     * 报警值
     */
    @TableField("fire_equipment_index_value")
    private String fireEquipmentIndexValue;

    /**
     * 发生频次
     */
    @TableField("frequency")
    private Integer frequency;

    /**
     * 报警状态：1报警0恢复
     */
    @TableField("status")
    private Boolean status;

    /**
     * 报警类型:alarm_type_fire（火灾报警）/alarm_type_trouble（故障告警）
     */
    @TableField("type")
    private String type;

    /**
     * 更新时间
     */
    @TableField("update_date")
    private Date updateDate;

    /**
     * 告警恢复时间
     */
    @TableField("recovery_date")
    private Date recoveryDate;

    /**
     * 确认类型
     */
    @TableField("confirm_type")
    private String confirmType;

    /**
     * 报警原因
     */
    @TableField("alam_reason")
    private String alamReason;

    /**
     * 处理情况
     */
    @TableField("resolve_result")
    private String resolveResult;

    /**
     * 确警人员
     */
    @TableField("confirm_user")
    private String confirmUser;

    /**
     * 确警人员姓名
     */
    @TableField("confirm_user_name")
    private String confirmUserName;

    /**
     * 确警时间
     */
    @TableField("confirm_date")
    private Date confirmDate;

    /**
     * 装备所属消防系统code
     */
    @TableField("system_mrids")
    private String systemMrids;

    /**
     * 装备定义code（冗余字段）
     */
    @TableField("equipment_definition_mrid")
    private String equipmentDefinitionMrid;

    /**
     * 装备定义名称
     */
    @TableField("equipment_definition_name")
    private String equipmentDefinitionName;

    /**
     * 设备位置
     */
    @TableField("location")
    private String location;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;
}
