package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 力量调派发送信息记录表
 *
 * @author litw
 * @date 2021-11-05
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_powerr_transfer_log")
public class PowerrTransferLog extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 队伍id
     */
	@TableField("team_id")
    private Long teamId;

    /**
     * 资源id(目前只有车辆)
     */
	@TableField("resource_id")
    private Long resourceId;

    /**
     * 接收人
     */
	@TableField("receive_name")
    private String receiveName;

    /**
     * 发送时间
     */
	@TableField("send_time")
    private String sendTime;

    /**
     * 发送内容
     */
	@TableField("send_content")
    private String sendContent;

}
