package com.yeejoin.amos.boot.module.ccs.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireEquipmentServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireEquipmentDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 消防设备资产
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "消防设备资产Api")
@RequestMapping(value = "/fire-equipment")
public class FireEquipmentController extends BaseController {

    @Autowired
    FireEquipmentServiceImpl fireEquipmentServiceImpl;

    /**
     * 新增消防设备资产
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增消防设备资产", notes = "新增消防设备资产")
	public ResponseModel<FireEquipmentDto> save(@RequestBody FireEquipmentDto model) {
	    model = fireEquipmentServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消防设备资产", notes = "根据sequenceNbr删除消防设备资产")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(fireEquipmentServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个消防设备资产",  notes = "根据sequenceNbr查询单个消防设备资产")
	public ResponseModel<FireEquipmentDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(fireEquipmentServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "消防设备资产分页查询",  notes = "消防设备资产分页查询")
	public ResponseModel<Page<FireEquipmentDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<FireEquipmentDto> page = new Page<FireEquipmentDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(fireEquipmentServiceImpl.queryForFireEquipmentPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "消防设备资产列表全部数据查询",   notes = "消防设备资产列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FireEquipmentDto>> selectForList() {
	    return ResponseHelper.buildResponse(fireEquipmentServiceImpl.queryForFireEquipmentList());
	}
}
