package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireRiskSourceDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireRiskSourceServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 风险点表
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "风险点表Api")
@RequestMapping(value = "/fire-risk-source")
public class FireRiskSourceController extends BaseController {

    @Autowired
    FireRiskSourceServiceImpl fireRiskSourceServiceImpl;

    /**
     * 新增风险点表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增风险点表", notes = "新增风险点表")
    public ResponseModel<FireRiskSourceDto> save(@RequestBody FireRiskSourceDto model) {
        model = fireRiskSourceServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除风险点表", notes = "根据sequenceNbr删除风险点表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireRiskSourceServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个风险点表", notes = "根据sequenceNbr查询单个风险点表")
    public ResponseModel<FireRiskSourceDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireRiskSourceServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "风险点表分页查询", notes = "风险点表分页查询")
    public ResponseModel<Page<FireRiskSourceDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireRiskSourceDto> page = new Page<FireRiskSourceDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireRiskSourceServiceImpl.queryForFireRiskSourcePage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "风险点表列表全部数据查询", notes = "风险点表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireRiskSourceDto>> selectForList() {
        return ResponseHelper.buildResponse(fireRiskSourceServiceImpl.queryForFireRiskSourceList());
    }
}
