package com.yeejoin.amos.boot.module.ccs.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.dto.FireRpnChangeLogDto;
import com.yeejoin.amos.boot.module.ccs.biz.service.impl.FireRpnChangeLogServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 风险点变化流水
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "风险点变化流水Api")
@RequestMapping(value = "/fire-rpn-change-log")
public class FireRpnChangeLogController extends BaseController {

    @Autowired
    FireRpnChangeLogServiceImpl fireRpnChangeLogServiceImpl;

    /**
     * 新增风险点变化流水
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增风险点变化流水", notes = "新增风险点变化流水")
    public ResponseModel<FireRpnChangeLogDto> save(@RequestBody FireRpnChangeLogDto model) {
        model = fireRpnChangeLogServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(model);
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除风险点变化流水", notes = "根据sequenceNbr删除风险点变化流水")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireRpnChangeLogServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个风险点变化流水", notes = "根据sequenceNbr查询单个风险点变化流水")
    public ResponseModel<FireRpnChangeLogDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(fireRpnChangeLogServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "风险点变化流水分页查询", notes = "风险点变化流水分页查询")
    public ResponseModel<Page<FireRpnChangeLogDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FireRpnChangeLogDto> page = new Page<FireRpnChangeLogDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(fireRpnChangeLogServiceImpl.queryForFireRpnChangeLogPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "风险点变化流水列表全部数据查询", notes = "风险点变化流水列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FireRpnChangeLogDto>> selectForList() {
        return ResponseHelper.buildResponse(fireRpnChangeLogServiceImpl.queryForFireRpnChangeLogList());
    }
}
