package com.yeejoin.amos.fas.business.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomUtil {
    private static ThreadLocalRandom threadLocalRandom;

    public static String buildOrderNo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String newDate = sdf.format(new Date());
        String result = "";
        Random random = new Random();
        for (int i = 0; i < 3; i++) {
            result += random.nextInt(10);
        }
        return newDate + result;
    }

    /**
     * @param resourceType 资源类型
     * @param companyCode  单位编号
     * @Description Random存在性能问题可能造成线程阻塞问题，使
     * 用性能更加卓越的threadLocalRandom（线程安全的单例模式）生成随机数
     * 四位随机数无法保证不可重复性，如果对不可重复要求高，请使用其他工具
     * @Author songLei
     * @Return String
     * @Date 2020/12/18 11:49
     */
    public static String buildNo(String resourceType, String companyCode) {
        threadLocalRandom = ThreadLocalRandom.current();
        int num = threadLocalRandom.nextInt(1000, 9999);
        return resourceType + companyCode + num;
    }

    public static String buildNo() {
        threadLocalRandom = ThreadLocalRandom.current();
        int num = threadLocalRandom.nextInt(1000, 9999);
        return String.valueOf(num);
    }
}
