package com.yeejoin.amos.patrol.feign;

import java.util.List;

import org.springframework.stereotype.Service;

import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import com.yeejoin.amos.patrol.business.param.PushMsgParam;

@Service("pushFeignServer")
public class PushFeignServer {
	    
	public void sendMessage( String toke,String product,String appKey, List<PushMsgParam> pushMsgParam){
			 try {
				    pushMsgParam.forEach(action->{
				    	sendJP(action);
				    });
				} catch (Exception e) {
					e.printStackTrace();	 
				}
		}
	    
	    
	public void sendMessage( String toke,String product,String appKey, PushMsgParam pushMsgParam){
			 try {
				 sendJP(pushMsgParam);
				} catch (Exception e) {
					e.printStackTrace();	 
				}
		}
	    
	    private void sendJP(PushMsgParam pushMsgParam){
	    	MessageModel model = new MessageModel();
	    	model.setRelationId(pushMsgParam.getRelationId());
	    	model.setTitle(pushMsgParam.getSubject());
	    	model.setBody(pushMsgParam.getContent());
	    	model.setMsgType("patrolSystem");
	    	model.setIsSendApp(true);
	    	model.setRecivers(pushMsgParam.getRecivers());
	    	model.setExtras(pushMsgParam.getExtras());
		    Systemctl.messageClient.create(model);
	    }
}
