package com.yeejoin.amos.supervision.rule.action;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.component.rule.RuleActionBean;
import com.yeejoin.amos.component.rule.RuleMethod;
import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.MessageModel;
import com.yeejoin.amos.supervision.business.util.MsgParamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

/**
 * @Author: xl
 * @Description: 消息规则动作
 * @Date: 2021/11/10 11:49
 */
@Component
@RuleActionBean(beanLabel = "消息发送")
public class MessageAction {

    public static final Logger log = LoggerFactory.getLogger(MessageAction.class);

    @RuleMethod(methodLabel = "消息发送", project = "消息")
    public void sendMessage(Object msgObj, String title, String content) {
        MessageModel messageModel = JSON.parseObject(JSON.toJSONString(msgObj), MessageModel.class);
        messageModel.setTitle(title);
        messageModel.setBody(MsgParamUtils.instedParams(content, msgObj));
        if (!ValidationUtil.isEmpty(messageModel)) {
            try {
                Systemctl.messageClient.create(messageModel);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}


