select temp.*
from (
         SELECT a.*,
                MAX(CASE WHEN i.field_label like '%面积%' THEN i.field_value END) area,
                MAX(CASE WHEN i.field_label like '%耐火%' THEN i.field_value END) level,
                case
                    when i.group_type = 'building' then '建筑'
                    when i.group_type = 'floor' then '楼层'
                    when i.group_type = 'room' then '房间'
                    end as                                                      type
         FROM (
                  SELECT t.id,
                         t.`code`  code,
                         t.`name`  name,
                         t1.`code` parentCode
                  FROM wl_warehouse_structure t
                           LEFT JOIN wl_warehouse_structure t1 ON t.parent_id = t1.id
              ) a,
              wl_form_instance i
         WHERE i.instance_id = a.id
         group by a.id,i.group_type
     ) temp