package com.yeejoin.amos.boot.module.jcs.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.common.api.dto.RequestData;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledTodyDto;
import com.yeejoin.amos.boot.module.jcs.api.dto.AlertCalledZhDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.AlertCalled;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
* 警情接警记录 Mapper 接口
*
* @author tb
* @date 2021-06-17
*/
public interface AlertCalledMapper extends BaseMapper<AlertCalled> {

    /**
     * 接警情况统计-交接班用
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    Map<String, Integer> queryAlertStatusCount(@Param("beginDate") String beginDate, @Param("endDate") String endDate);

    List<AlertCalledZhDto> alertCalledListByAlertStatus(@Param("pageNum")Integer pageNum, @Param("pageSize")Integer pageSize,@Param("par")RequestData par);

    int  alertCalledListByAlertStatusCount(@Param("par")RequestData par);

    Integer AlertCalledcountTime(@Param("type")int type);

    List<AlertCalledTodyDto> getTodayAlertCalled();

    List<String> getContactName( );

    List<String> getAddress();

    List<AlertCalled> selectAllPage(Long current, Long size,
                                    Integer alertStatus,
                                    String alertTypeCode ,
                                    String alertSourceCode,
                                    String startTime,
                                    String endTime,
                                    String data,
                                    String lift);


    Integer AlertCalledcount(@Param("alertStatus")int alertStatus);

     //未结束灾情列表
    List<AlertCalled> AlertCalledStatusPage(@Param("current")Integer current, @Param("size")Integer size);
}
