package com.yeejoin.amos.supervision.common.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public enum CheckTypeSuEnum {

    SUPERVISED("日常检查", "1", "supervised"),
    DAILY("专项检查", "2", "daily");

    /**
     * 名字
     */
    private String name;
    /**
     * 编号
     */
    private String code;

    /**
     * 执行控制条件
     */
    private String condition;

    CheckTypeSuEnum(String name, String code, String condition) {
        this.name = name;
        this.code = code;
        this.condition = condition;
    }

    public static List<Map<String, Object>> getEnumList() {
        return Arrays.stream(CheckTypeSuEnum.values()).map(e -> {
            Map<String, Object> map = new HashMap<>();
            map.put(e.getCode(), e.getName());
            return map;
        }).collect(Collectors.toList());
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCondition() {
        return condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}
