package com.yeejoin.amos.api.openapi.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.format.DateTimeFormat;
import com.yeejoin.amos.api.openapi.converter.*;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "西安电梯数据对接", description = "西安电梯数据对接")
public class XiAnElevatorExcelDto extends BaseDto {

    @ExcelIgnore
    private static final long serialVersionUID = 1L;

    //----------------------------------------------------------------------基本信息
    @ApiModelProperty(value = "设备种类")
    @ExcelProperty(value = "设备种类", converter = EquListConverter.class)
    @NotBlank(message = "设备种类不能为空")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    @ExcelProperty(value = "设备类别", converter = EquCategoryConverter.class)
    @NotBlank(message = "设备类别不能为空")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    @ExcelProperty(value = "设备品种", converter = EquDefineConverter.class)
    private String equDefine;

    @ApiModelProperty(value = "单位内编号")
    @ExcelProperty(value = "单位内编号")
    private String useInnerCode;

    @ApiModelProperty(value = "产品名称")
    @ExcelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "设备型号")
    @ExcelProperty(value = "设备型号")
    @NotBlank(message = "设备型号不能为空")
    private String equType;

    @ApiModelProperty(value = "设备总价值（万元）")
    @ExcelProperty(value = "设备总价值（万元）")
    private String equPrice;

    @ApiModelProperty(value = "有无设备代码")
    @ExcelProperty(value = "有无设备代码", converter = EquCodeTypeConverter.class)
    @NotBlank(message = "有无设备代码不能为空")
    private String equCodeType;

    @ApiModelProperty(value = "设备代码")
    @ExcelProperty(value = "设备代码")
    private String equCode;

    @ApiModelProperty(value = "96333码")
    @ExcelProperty(value = "96333码")
    private String code96333;

    @ApiModelProperty(value = "使用登记证编号")
    @ExcelProperty(value = "使用登记证编号")
    private String useOrgCode;

    @ApiModelProperty(value = "注册代码")
    @ExcelProperty(value = "注册代码")
    private String record;

    //-----------------------------------------------------------------------使用信息
    @ApiModelProperty(value = "使用单位统一社会信用代码")
    @ExcelProperty(value = "使用单位统一社会信用代码")
    @NotBlank(message = "使用单位统一社会信用代码不能为空")
    private String useUnitCode;

    @ApiModelProperty(value = "使用单位名称")
    @ExcelProperty(value = "使用单位名称")
    @NotBlank(message = "使用单位名称不能为空")
    private String useUnit;

    @ApiModelProperty(value = "产权单位统一信用代码")
    @ExcelProperty(value = "产权单位统一信用代码")
    private String estateUnitCreditCode;

    @ApiModelProperty(value = "产权单位统一信用代码")
    @ExcelProperty(value = "产权单位统一信用代码")
    private String estateUnitName;

    @ApiModelProperty(value = "使用地点-省")
    @ExcelProperty(value = "使用地点-省")
    private String provinceName;

    @ApiModelProperty(value = "使用地点-市")
    @ExcelProperty(value = "使用地点-市")
    private String cityName;

    @ApiModelProperty(value = "使用地点-区/县")
    @ExcelProperty(value = "使用地点-区/县")
    private String countyName;

    @ApiModelProperty(value = "使用地点-街道")
    @ExcelProperty(value = "使用地点-街道")
    private String factoryUseSiteStreet;

    @ApiModelProperty(value = "详细地址")
    @ExcelProperty(value = "详细地址")
    private String address;

    @ApiModelProperty(value = "使用地点经纬度")
    @ExcelProperty(value = "使用地点经纬度")
    private String longitudeLatitude;

    @ApiModelProperty(value = "使用场所")
    private String usePlace;

    @ApiModelProperty(value = "安全管理员")
    @ExcelProperty(value = "安全管理员")
    private String safetyManager;

    @ApiModelProperty(value = "安全管理员联系电话")
    @ExcelProperty(value = "安全管理员联系电话")
    private String phone;

    @ApiModelProperty(value = "安全管理员身份证号")
    @ExcelProperty(value = "安全管理员身份证号")
    private String safetyManagerIDNumber;

    //---------------------------------------------------------------制造信息

    @ApiModelProperty(value = "制造单位统一社会信用代码")
    @ExcelProperty(value = "制造单位统一社会信用代码")
    @NotBlank(message = "制造单位统一社会信用代码不能为空")
    private String produceUnitCreditCode;

    @ApiModelProperty(value = "制造单位名称")
    @ExcelProperty(value = "制造单位名称")
    @NotBlank(message = "制造单位名称不能为空")
    private String produceUnitName;

    @ApiModelProperty(value = "制造许可编号")
    @ExcelProperty(value = "制造许可编号")
    @NotBlank(message = "制造许可编号不能为空")
    private String produceLicenseNum;

    @ApiModelProperty(value = "出厂编号/产品编码")
    @ExcelProperty(value = "出厂编号/产品编码")
    @NotBlank(message = "出厂编号/产品编码不能为空")
    private String factoryNum;

    @ApiModelProperty(value = "制造日期")
    @ExcelProperty(value = "制造日期")
    @DateTimeFormat("yyyy-MM-dd")
    private String produceDate;

    @ApiModelProperty(value = "是否进口")
    @ExcelProperty(value = "是否进口", converter = ImportedConverter.class)
    private String imported;

    @ApiModelProperty(value = "制造国")
    @ExcelProperty(value = "制造国")
    private String produceCountry;

    //---------------------------------------------------------------安装信息

    @ApiModelProperty(value = "安装单位名称")
    @ExcelProperty(value = "安装单位名称")
    private String installUnitName;

    @ApiModelProperty(value = "安装单位统一信用代码")
    @ExcelProperty(value = "安装单位统一信用代码")
    private String installUnitCreditCode;

    @ApiModelProperty(value = "安装负责人")
    @ExcelProperty(value = "安装负责人")
    private String installLeaderName;

    @ApiModelProperty(value = "安装负责人手机")
    @ExcelProperty(value = "安装负责人手机")
    private String installLeaderPhone;

    @ApiModelProperty(value = "安装负责人身份证号")
    @ExcelProperty(value = "安装负责人身份证号")
    private String installLeaderIDNumber;

    @ApiModelProperty(value = "安装日期")
    @ExcelProperty(value = "安装日期")
    @DateTimeFormat("yyyy-MM-dd")
    private Date noticeDate;

    //--------------------------------------------------------------------检验信息

    @ApiModelProperty(value = "检验机构名称")
    @ExcelProperty(value = "检验机构名称")
    private String inspectOrgName;

    @ApiModelProperty(value = "检验机构统一信用代码")
    @ExcelProperty(value = "检验机构统一信用代码")
    private String inspectOrgCode;

    @ApiModelProperty(value = "检验机构统一信用代码")
    private String inspectType;

    @ApiModelProperty(value = "检验结论")
    private String inspectConclusion;

    @ApiModelProperty(value = "检验日期")
    @ExcelProperty(value = "检验日期")
    @DateTimeFormat("yyyy-MM-dd")
    private Date inspectDate;

    @ApiModelProperty(value = "下次检验日期")
    @ExcelProperty(value = "下次检验日期")
    @DateTimeFormat("yyyy-MM-dd")
    private Date nextInspectDate;

    @ApiModelProperty(value = "检验人员名称")
    @ExcelProperty(value = "检验人员名称")
    private String inspectStaff;

    @ApiModelProperty(value = "检验人员身份证号")
    @ExcelProperty(value = "检验人员身份证号")
    private String inspectStaffIDNumber;

    @ApiModelProperty(value = "检验报告编号")
    @ExcelProperty(value = "检验报告编号")
    private String inspectReportNo;

    //--------------------------------------------------------------------维保信息
    @ApiModelProperty(value = "维保单位统一信用代码")
    @ExcelProperty(value = "维保单位统一信用代码")
    private String meUnitCreditCode;

    @ApiModelProperty(value = "维保单位")
    @ExcelProperty(value = "维保单位")
    private String meUnitName;

    @ApiModelProperty(value = "维保合同开始时间")
    @ExcelProperty(value = "维保合同开始时间")
    @DateTimeFormat("yyyy-MM-dd")
    private String informStart;

    @ApiModelProperty(value = "维保合同结束时间")
    @ExcelProperty(value = "维保合同结束时间")
    @DateTimeFormat("yyyy-MM-dd")
    private String informEnd;

    @ApiModelProperty(value = "维保人员一")
    @ExcelProperty(value = "维保人员一")
    private String meMaster;

    @ApiModelProperty(value = "维保人员一身份证号")
    @ExcelProperty(value = "维保人员一身份证号")
    private String meMasterId;

    @ApiModelProperty(value = "维保人员一联系方式")
    @ExcelProperty(value = "维保人员一联系方式")
    private String meMasterPhone;

    @ApiModelProperty(value = "维保人员二")
    @ExcelProperty(value = "维保人员二")
    private String meMaster1;

    @ApiModelProperty(value = "维保人员二身份证号")
    @ExcelProperty(value = "维保人员二身份证号")
    private String meMaster1Id;

    @ApiModelProperty(value = "维保人员二联系方式")
    @ExcelProperty(value = "维保人员二联系方式")
    private String meMaster1Phone;

    //--------------------------------------------------------------------电梯索道----技术参数
    @ApiModelProperty(value = "额定速度")
    @ExcelProperty(value = "额定速度")
    private BigDecimal ratedSpeed;

    @ApiModelProperty(value = "额定速度（上行）")
    @ExcelProperty(value = "额定速度（上行）")
    private BigDecimal ratedSpeedUp;

    @ApiModelProperty(value = "额定速度（下行）")
    @ExcelProperty(value = "额定速度（下行）")
    private BigDecimal ratedSpeedDown;

    @ApiModelProperty(value = "提升高度（m）")
    @ExcelProperty(value = "提升高度（m）")
    private BigDecimal liftingHeight;

    @ApiModelProperty(value = "额定载重量")
    @ExcelProperty(value = "额定载重量")
    private BigDecimal ratedLoadCapacity;

    @ApiModelProperty(value = "层数（层）")
    @ExcelProperty(value = "层数（层）")
    private Integer storey;

    @ApiModelProperty(value = "站数（站）")
    @ExcelProperty(value = "站数（站）")
    private Integer stand;

    @ApiModelProperty(value = "门数")
    @ExcelProperty(value = "门数")
    private Integer numberDoors;

    @ApiModelProperty(value = "控制方式")
    @ExcelProperty(value = "控制方式", converter = DictParamsConverter.class)
    private String controlMode;

    @ApiModelProperty(value = "名义速度（m/s）")
    @ExcelProperty(value = "名义速度（m/s）")
    private BigDecimal nominalSpeed;

    @ApiModelProperty(value = "倾斜角")
    @ExcelProperty(value = "倾斜角")
    private BigDecimal angleRoll;

    @ApiModelProperty(value = "名义宽度（mm）")
    @ExcelProperty(value = "名义宽度（mm）")
    private BigDecimal nominalWidth;

    @ApiModelProperty(value = "使用区段长度（m）")
    @ExcelProperty(value = "使用区段长度（m）")
    private BigDecimal useSectionLength;

    @ApiModelProperty(value = "输送能力（P/h）")
    @ExcelProperty(value = "输送能力（P/h）")
    private String conveyingCapacity;

    @ApiModelProperty(value = "油缸数量")
    @ExcelProperty(value = "油缸数量")
    private Integer numberCylinders;

    @ApiModelProperty(value = "顶升型式")
    @ExcelProperty(value = "顶升型式", converter = DictParamsConverter.class)
    private String jackingType;

    @ApiModelProperty(value = "整机防爆标志")
    @ExcelProperty(value = "整机防爆标志")
    private String explosionproofSignComplete;

    @ApiModelProperty(value = "防爆等级")
    @ExcelProperty(value = "防爆等级", converter = DictParamsConverter.class)
    private String explosionproofGrade;

    @ApiModelProperty(value = "轿门位置")
    @ExcelProperty(value = "轿门位置")
    private String doorPosition;

    @ApiModelProperty(value = "原设备代码")
    @ExcelIgnore
    private String originalEquCode;

    @ApiModelProperty(value = "序号")
    @ExcelProperty(value = "序号")
    private String xaSerial;

    @ApiModelProperty(value = "资料是否齐全（0齐全， 1不齐全）-西安数据导入")
    @ExcelIgnore
    private Integer isCompleteXa;
}