package com.yeejoin.amos.boot.module.jczs.flc.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 配套设备/设施/部件
 *
 * @author system_generator
 * @date 2021-11-26
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="EquipmentAssociatedDto", description="配套设备/设施/部件")
public class EquipmentAssociatedDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "设备id")
    private Long equipmentId;

    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "型号")
    private String model;

    @ApiModelProperty(value = "规格")
    private String specifications;

    @ApiModelProperty(value = "编号")
    private String code;

    @ApiModelProperty(value = "数量")
    private Integer amount;

    @ApiModelProperty(value = "制造单位")
    private String manufacturer;

    @ApiModelProperty(value = "制造日期")
    private Date productionDate;

    @ApiModelProperty(value = "部件/装置号")
    private String partNumber;

    @ApiModelProperty(value = "型式试验合格证号")
    private String certificateNumber;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "鉴定机构名称")
    private String appraisalAgencyName;

    @ApiModelProperty(value = "设计文件鉴定日期")
    private Date appraisalDate;

    @ApiModelProperty(value = "鉴定报告书编号")
    private String appraisalReportNumber;

    @ApiModelProperty(value = "监检检验机构")
    private String supervisoryInspectionAgency;

    @ApiModelProperty(value = "统一社会信用代码")
    private String socialCreditCode;

    @ApiModelProperty(value = "机构核准证编号")
    private String approvalCertificateNumber;

    @ApiModelProperty(value = "更新人id")
    private Long recUserD;

}
