package com.yeejoin.amos.boot.module.common.api.excel;

import cn.hutool.core.util.ZipUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.google.common.collect.Lists;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class ExcelUtil {

    private static final Integer DUTY_CAR_START_INDEX = 5;

    public static byte[] generateExcelBytes(String sheetName, List<?> data, List<List<String>> heads,
                             List<String> headStr, String fileType) {
        // 1. 设置单元格样式
        HorizontalCellStyleStrategy horizontalCellStyleStrategy = setMyCellStyle();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream()) {
            try {
                List<List<Object>> listData = new ArrayList<>();
                for (Object obj : data) {
                    List<Object> rowData = new ArrayList<>();
                    for (String head : headStr) {
                        String methodName = "get" + head.substring(0, 1).toUpperCase() + head.substring(1);
                        Method getMethod = obj.getClass().getMethod(methodName);
                        Object value = getMethod.invoke(obj);
                        rowData.add(value);
                    }
                    listData.add(rowData);
                }

                ExcelTypeEnum typeEnum = "1039".equals(fileType) ? ExcelTypeEnum.XLS : ExcelTypeEnum.XLSX;

                EasyExcel.write(outputStream)
                        .excelType(typeEnum)
                        .sheet(sheetName)
                        .registerWriteHandler(new TemplateCellWriteHandler()) // 保留自定义处理器
                        .registerWriteHandler(horizontalCellStyleStrategy)    // 保留样式策略
                        .head(heads)
                        .doWrite(listData);
                return outputStream.toByteArray();
            } catch (Exception e) {
                throw new RuntimeException("生成Excel失败: " + e.getMessage(), e);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return new byte[0];
    }

    /**
     * 生成excel模板
     *
     * @param response
     * @param fileName  下载的文件名，
     * @param sheetName sheet名
     * @param data      导出的数据
     * @param model     导出的头
     * @param flag      true模板填充下拉 false 不填充
     */
    public static void createTemplate(HttpServletResponse response, String fileName, String sheetName,
                                      List<? extends Object> data, Class<?> model, DataSources dataDictionaryMapper, boolean flag) {

        HorizontalCellStyleStrategy horizontalCellStyleStrategy = setMyCellStyle();
        try {
            // 下拉列表集合
            Map<Integer, String[]> explicitListConstraintMap = new HashMap<>();
            if (flag) {
                // 循环获取对应列得下拉列表信息
                Field[] declaredFields = model.getDeclaredFields();
                for (int i = 0; i < declaredFields.length; i++) {
                    Field field = declaredFields[i];
                    // 解析注解信息
                    ExplicitConstraint explicitConstraint = field.getAnnotation(ExplicitConstraint.class);
                    resolveExplicitConstraint(explicitListConstraintMap, explicitConstraint, dataDictionaryMapper);
                }
            }
            EasyExcel.write(getOutputStream(fileName, response, ExcelTypeEnum.XLSX), model)
                    .excelType(ExcelTypeEnum.XLSX).sheet(sheetName)
                    .registerWriteHandler(new TemplateCellWriteHandlerDate(explicitListConstraintMap))
                    .registerWriteHandler(new TemplateCellWriteHandler())
                    .registerWriteHandler(horizontalCellStyleStrategy).doWrite(data);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");

        }
    }

    /**
     * 生成excel模板
     *
     * @param response
     * @param fileName  下载的文件名，
     * @param sheetName sheet名
     * @param data      导出的数据
     * @param model     导出的头
     * @param flag      true模板填充下拉 false 不填充
     */
    public static void createDutyTemplate(HttpServletResponse response, String fileName, String sheetName,
                                          List<? extends Object> data, Class<?> model, List<String> dayByMonth, String[] dutyNameList,
                                          DataSources dataDictionaryMapper, boolean flag, String typeFlag, boolean isTemplete) {

        HorizontalCellStyleStrategy horizontalCellStyleStrategy = setMyCellStyle();
        try {
            // 组装表头
            List<List<String>> dutyCarTitleList = new ArrayList<>();
            Field[] declaredFields = model.getDeclaredFields();
            for (int i = 0; i < declaredFields.length; i++) {
                Field field = declaredFields[i];
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                if (excelProperty != null) {
                    ArrayList<String> head = new ArrayList<>();
                    head.add(excelProperty.value()[0]);
                    dutyCarTitleList.add(head);
                }
            }
            int size = dutyCarTitleList.size();
            if (dayByMonth != null) {
                for (int i = 0; i < dayByMonth.size(); i++) {
                    ArrayList<String> dutyDay = new ArrayList<>();
                    dutyDay.add(dayByMonth.get(i));
                    dutyCarTitleList.add(dutyDay);
                }
            }
            // 下拉列表集合
            Map<Integer, String[]> explicitListConstraintMap = new HashMap<>();
            if (flag) {
                // 组装下拉列表
                for (int i = 0; i < declaredFields.length; i++) {
                    Field field = declaredFields[i];
                    // 解析注解信息
                    ExplicitConstraint explicitConstraint = field.getAnnotation(ExplicitConstraint.class);
                    resolveExplicitConstraint(explicitListConstraintMap, explicitConstraint, dataDictionaryMapper);
                }
                if (dayByMonth != null) {
                    for (int i = 0; i < dayByMonth.size(); i++) {
                        explicitListConstraintMap.put(size + i, dutyNameList);
                    }
                }
            }
//            String s = new String(fileName.getBytes(), "UTF-8");
//            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(s, "UTF-8"));

            ExcelWriterSheetBuilder excelWriterSheetBuilder = EasyExcel
                    .write(getOutputStream(fileName, response, ExcelTypeEnum.XLSX))
                    .head(dutyCarTitleList)
                    .excelType(ExcelTypeEnum.XLSX).sheet(sheetName);
            if ("WXXFZB".equals(typeFlag) && isTemplete) {
                List<Map<Integer, String[]>> fireStationExplicitListConstraintMap = new ArrayList<Map<Integer, String[]>>();
                List<List<Object>> resultList = new ArrayList<List<Object>>();
                data.stream().forEach(i -> {
                    Map<Integer, String[]> map = new HashMap<>();
                    List<Object> detail = (List<Object>) i;
                    // 微型消防站中的对应单位微型消防站下拉列表数据的集合
                    List<String> fireStationDetailList = (List<String>) detail.get(detail.size() - 1);
                    String[] strings = new String[fireStationDetailList.size()];
                    map.put(4, fireStationDetailList.toArray(strings));
                    map.putAll(explicitListConstraintMap);
                    fireStationExplicitListConstraintMap.add(map);
                    detail.remove(detail.size() - 1);
                    resultList.add(detail);
                });
                excelWriterSheetBuilder.registerWriteHandler(
                        new TemplateDynamicCellWriteHandlerDate(fireStationExplicitListConstraintMap))
                        .registerWriteHandler(new TemplateCellWriteHandler())
                        .registerWriteHandler(horizontalCellStyleStrategy);
                excelWriterSheetBuilder.doWrite(resultList);
            } else if ("JJZB".equals(typeFlag) && isTemplete) {
                List<Map<Integer, String[]>> fireStationExplicitListConstraintMap = new ArrayList<Map<Integer, String[]>>();
                List<List<Object>> resultList = new ArrayList<List<Object>>();
                data.stream().forEach(i -> {
                    Map<Integer, String[]> map = new HashMap<>();
                    List<Object> detail = (List<Object>) i;
                    // 微型消防站中的对应单位微型消防站下拉列表数据的集合
                    List<String> fireStationDetailList = (List<String>) detail.get(detail.size() - 1);
                    String[] strings = new String[fireStationDetailList.size()];
                    List<String> postTypeNameDetailList = (List<String>) detail.get(detail.size() - 2);
                    String[] postTypeNamestrings = new String[postTypeNameDetailList.size()];
                    List<String> userNameDetailList = (List<String>) detail.get(detail.size() - 3);
                    String[] userNamestrings = new String[userNameDetailList.size()];
                    List<String> companyNameList = (List<String>) detail.get(detail.size() - 4);
                    String[] companyNameLists = new String[companyNameList.size()];
                    map.put(4, fireStationDetailList.toArray(strings));
                    map.put(3, postTypeNameDetailList.toArray(postTypeNamestrings));
                    map.put(2, userNameDetailList.toArray(userNamestrings));
                    map.put(1, companyNameList.toArray(companyNameLists));
                    map.putAll(explicitListConstraintMap);
                    fireStationExplicitListConstraintMap.add(map);
                    detail.remove(detail.size() - 1);
                    detail.remove(detail.size() - 1);
                    detail.remove(detail.size() - 1);
                    detail.remove(detail.size() - 1);
                    resultList.add(detail);
                });
                excelWriterSheetBuilder
                        .registerWriteHandler(
                                new TemplateDynamicCellWriteHandlerDate(fireStationExplicitListConstraintMap))
                        .registerWriteHandler(new TemplateCellWriteHandler())
                        .registerWriteHandler(horizontalCellStyleStrategy);
                excelWriterSheetBuilder.doWrite(resultList);
            } else {
                excelWriterSheetBuilder = excelWriterSheetBuilder
                        .registerWriteHandler(
                                new TemplateCellWriteHandlerDate(explicitListConstraintMap))
                        .registerWriteHandler(new TemplateCellWriteHandler())
                        .registerWriteHandler(horizontalCellStyleStrategy);
                excelWriterSheetBuilder.doWrite(data);
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");

        }
    }

    /**
     * 读取 Excel(第一个 sheet) 指定行开始读取
     *
     * @param excel   文件
     * @param rowType 模板实体类
     * @param header  指定不读取的表头行数，
     * @param <T>
     * @return 集合数据
     * @throws Exception
     */
    public static <T> List<T> readFirstSheetExcel(MultipartFile excel, Class<T> rowType, int header) throws Exception {
        ExcelReader reader = getReader(excel, header);
        if (reader == null) {
            return new ArrayList<>();
        }
        return readExcel(reader, rowType, 0);
    }

    /**
     * 读取 Excel(多个 sheet)
     *
     * @param reader     读取的excel
     * @param rowModel   excel模板实体类
     * @param sheetCount sheet
     * @param <T>
     * @return
     */
    public static <T> List<T> readExcel(ExcelReader reader, Class<T> rowModel, int sheetCount) {
        if (reader == null) {
            return new ArrayList<>();
        }
        ExcelListener<T> excelListener = new ExcelListener<>();
        ReadSheet readSheet = EasyExcel.readSheet(sheetCount).head(rowModel).registerReadListener(excelListener)
                .build();
        reader.read(readSheet);
        return excelListener.getList();
    }

    /**
     * @param excel  需要解析的 Excel 文件
     * @param header 指定不读取表头行数，
     * @return
     * @throws Exception
     */
    public static ExcelReader getReader(MultipartFile excel, int header) throws Exception {
        String fileName = excel.getOriginalFilename();
        if (fileName == null) {
            throw new Exception("文件不存在！");
        }
        if (!fileName.toLowerCase().endsWith(ExcelTypeEnum.XLS.getValue())
                && !fileName.toLowerCase().endsWith(ExcelTypeEnum.XLSX.getValue())) {
            throw new Exception("文件类型异常！");
        }
        InputStream inputStream;
        try {
            inputStream = excel.getInputStream();
            return EasyExcel.read(inputStream).headRowNumber(header).build();
        } catch (IOException e) {
            // do something
        }
        return null;
    }

    /**
     * 解析注解内容 获取下列表信息
     *
     * @param explicitConstraint
     * @return
     */
    public static Map<Integer, String[]> resolveExplicitConstraint(Map<Integer, String[]> explicitListConstraintMap,
                                                                   ExplicitConstraint explicitConstraint, DataSources dataDictionaryMapper) {
        if (explicitConstraint == null) {
            return null;
        }
        // 固定下拉信息
        String[] source = explicitConstraint.source();
        if (source.length > 0) {
            explicitListConstraintMap.put(explicitConstraint.indexNum(), source);
        }
        // 动态下拉信息
        Class<? extends ExplicitInterface>[] classes = explicitConstraint.sourceClass();
        if (classes.length > 0) {
            ExplicitInterface explicitInterface = null;
            try {
                explicitInterface = classes[0].newInstance();
                String[] source1 = explicitInterface.source(explicitConstraint.type(), explicitConstraint.method(),
                        dataDictionaryMapper);
                if (source1.length > 0) {
                    explicitListConstraintMap.put(explicitConstraint.indexNum(), source1);
                }
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    /**
     * 导出文件时为Writer生成OutputStream
     */
    private static OutputStream getOutputStream(String fileName, HttpServletResponse response,
                                                ExcelTypeEnum excelTypeEnum) throws Exception {
        // 创建本地文件
        String filePath = fileName + excelTypeEnum.getValue();
        try {
            fileName = new String(filePath.getBytes(), "UTF-8");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setContentType("application/vnd.ms-excel");
            response.addHeader("Content-Disposition", "filename=" + fileName);
            response.setHeader("Content-Disposition",
                    "attachment; filename=" + URLEncoder.encode(fileName, StandardCharsets.UTF_8.name()));
            return response.getOutputStream();
        } catch (IOException e) {
            throw new Exception("系统异常");
        }
    }

    /**
     * 创建我的cell 策略
     *
     * @return
     */
    public static HorizontalCellStyleStrategy setMyCellStyle() {

//        // 头的策略
//        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
//        // 设置表头居中对齐
//        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
//        // 颜色
//        headWriteCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
//        
//        WriteFont headWriteFont = new WriteFont();
//        headWriteFont.setFontHeightInPoints((short) 10);
//        // 字体
//        headWriteCellStyle.setWriteFont(headWriteFont);
//        headWriteCellStyle.setWrapped(true);    
//        // 内容的策略
//        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
//        // 设置内容靠中对齐
//        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
//        // 这个策略是 头是头的样式 内容是内容的样式 其他的策略可以自己实现
//        HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy
//        (headWriteCellStyle, contentWriteCellStyle);
//        // 这里 需要指定写用哪个class去写，然后写到第一个sheet，名字为模板 然后文件流会自动关闭   
//        return horizontalCellStyleStrategy;

        // 表头样式策略
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        // 设置表头居中对齐
        headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        // 表头前景色
        headWriteCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setBold(true);
        headWriteFont.setFontName("宋体");
        headWriteFont.setFontHeightInPoints((short) 10);
        headWriteCellStyle.setWriteFont(headWriteFont);

        // 2 内容样式策略
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        WriteFont contentWriteFont = new WriteFont();
        // 内容字体大小
        contentWriteFont.setFontName("宋体");
        contentWriteFont.setFontHeightInPoints((short) 10);
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        // 设置自动换行
        contentWriteCellStyle.setWrapped(true);
        // 设置垂直居中
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        // 头默认了 FillPatternType所以可以不指定。
        // contentWriteCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
        // 设置水平居中
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);

        // 设置边框样式
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);

        return new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }


    /**
     * 生成excel模板
     *
     * @param response
     * @param fileName  下载的文件名，
     * @param sheetName sheet名
     * @param data      导出的数据
     */
    public static void createTemplateWithHeaders(HttpServletResponse response, String fileName, String sheetName,
                                                 List<? extends Object> data, List<List<String>> heads, List<String> headstr, String fileType) {

        HorizontalCellStyleStrategy horizontalCellStyleStrategy = setMyCellStyle();
        try {
            // 下拉列表集合
            List<List<Object>> listData = Lists.newArrayList();
            for (Object t : data) {
                List<Object> rowLine = new ArrayList<>();
                for (String head : headstr) {
                    List<Object> row = new ArrayList<>();
                    String getMethodName = "get" + head.substring(0, 1).toUpperCase() + head.substring(1);
                    Class clazz = t.getClass();
                    Method getMethod;
                    getMethod = clazz.getMethod(getMethodName, new Class[]{});
                    Object value = getMethod.invoke(t, new Object[]{});
                    rowLine.add(value);
                }
                listData.add(rowLine);
            }

            ExcelTypeEnum typeEnum = null;
            if ("1039".equals(fileType)) {
                typeEnum = ExcelTypeEnum.XLS;
            } else if ("1040".equals(fileType)) {
                typeEnum = ExcelTypeEnum.XLSX;
            }

            EasyExcel.write(getOutputStream(fileName, response, typeEnum))
                    .excelType(typeEnum).sheet(sheetName)
                    .registerWriteHandler(new TemplateCellWriteHandler())
                    .registerWriteHandler(horizontalCellStyleStrategy)
                    .head(heads).doWrite(listData);
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("系统异常！");

        }
    }


    private static ByteArrayOutputStream exportData2(List<?> subList, List<List<String>> heads) {
        ByteArrayOutputStream singleOutputStream = new ByteArrayOutputStream();
        ExcelWriter excelWriter = EasyExcel.write(singleOutputStream).build();
        WriteSheet writeSheet = EasyExcel.writerSheet("电梯信息").build();
        writeSheet.setHead(heads);
        excelWriter.write(subList, writeSheet);
        excelWriter.finish();
        return singleOutputStream;
    }


    public static void exportWithMplThread2(HttpServletResponse response,
                                            String fileName,
                                            List<?> data,
                                            List<List<String>> heads,
                                            String fileType,
                                            Executor executorService,
                                            int pageSize) {
        int dataSize = data.size();
        int excelNumber = (int)Math.ceil((double)dataSize/pageSize);
        int lastDataSize = dataSize % pageSize;
        List<CompletableFuture<ByteArrayOutputStream>> futures = new ArrayList<>();
        for (int i = 0; i < excelNumber; i++) {
            int start = i * pageSize;
            int end = start + pageSize;

            if (i == excelNumber - 1) {
                end = start + (lastDataSize == 0 ? pageSize : lastDataSize);
            }
            List<?> subList = data.subList(start, end);
            CompletableFuture<ByteArrayOutputStream> future = CompletableFuture.supplyAsync(() -> exportData2(subList, heads), executorService)
                    .exceptionally(ex -> {
                        ex.printStackTrace();
                        return null; // Handle exception and return a default result or null
                    });
            futures.add(future);
        }

        CompletableFuture<Void> allOfFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletableFuture<List<ByteArrayOutputStream>> combinedFuture = allOfFuture
                .thenApply(v -> futures.stream()
                        .map(CompletableFuture::join)
                        .collect(Collectors.toList()));

        List<ByteArrayOutputStream> results = combinedFuture.join();
        try {
            String encodedFileName = URLEncoder.encode(fileName + ".zip", StandardCharsets.UTF_8.name());
            response.setContentType("application/zip");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("Content-Disposition", "attachment; filename=" + encodedFileName);
            List<File> tempList = new ArrayList<>();
            ExcelTypeEnum typeEnum;
            if ("1039".equals(fileType)) {
                typeEnum = ExcelTypeEnum.XLS;
            } else {
                typeEnum = ExcelTypeEnum.XLSX;
            }
            results.forEach(b -> {
                try {
                    File tempFile = File.createTempFile(fileName, typeEnum.getValue());
                    Files.write(tempFile.toPath(), b.toByteArray(), StandardOpenOption.CREATE);
                    tempList.add(tempFile);
                } catch (IOException e) {
                    e.printStackTrace();
                }
            });

            File[] tempFiles = tempList.toArray(new File[0]);
            File zipFile = new File(fileName + ".zip");
            ZipUtil.zip(zipFile, false, tempFiles);

            Arrays.stream(tempFiles).forEach(File::delete);

            try (OutputStream outputStream = response.getOutputStream();
                 FileInputStream zipFileStream = new FileInputStream(zipFile);
                 BufferedInputStream inputStream = new BufferedInputStream(zipFileStream)) {
                byte[] buffer = new byte[8192];
                int count;
                while ((count = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, count);
                }
            } catch (Exception e) {
                e.printStackTrace();
            } finally {
                zipFile.delete();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


}
