package com.yeejoin.amos.boot.module.common.api.dto;

import lombok.Data;
import lombok.experimental.Accessors;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;

/**
 * @Author cpp
 * @Description
 * @Date 2023/6/5
 */
@Data
@Accessors(chain = true)
@Document(indexName = "idx_biz_view_jg_all", shards = 6, replicas = 2)
public class ESEquipmentCategoryDto {

    @Id
    private String SEQUENCE_NBR;

    @Field(type = FieldType.Text)
    private String ORG_BRANCH_NAME;

    @Field(type = FieldType.Text)
    private String ORG_BRANCH_CODE;

    @Field(type = FieldType.Text)
    private String USE_UNIT_NAME;

    @Field(type = FieldType.Text)
    private String USE_UNIT_CREDIT_CODE;

    @Field(type = FieldType.Keyword)
    private String EQU_LIST_CODE;

    @Field(type = FieldType.Text)
    private String EQU_LIST;

    @Field(type = FieldType.Text)
    private String EQU_CATEGORY;

    @Field(type = FieldType.Keyword)
    private String EQU_CATEGORY_CODE;

    @Field(type = FieldType.Keyword)
    private String USE_ORG_CODE;

    @Field(type = FieldType.Text)
    private String CODE96333;

    @Field(type = FieldType.Text)
    private String EQU_CODE;

    @Field(type = FieldType.Keyword)
    private String SUPERVISORY_CODE;

    @Field(type = FieldType.Text)
    private String USE_PLACE;

    @Field(type = FieldType.Text)
    private String ADDRESS;

    @Field(type = FieldType.Integer)
    private Integer EQU_STATE;

    @Field(type = FieldType.Keyword)
    private String STATUS;

    @Field(type = FieldType.Long)
    private Long REC_DATE;

    @Field(type = FieldType.Text)
    private String SAFETY_MANAGER;

    @Field(type = FieldType.Text)
    private String PHONE;

    @Field(type = FieldType.Text)
    private String MAINTAIN_UNIT;

    @Field(type = FieldType.Text)
    private String USE_INNER_CODE;

    @Field(type = FieldType.Text)
    private String FACTORY_NUM;

    @Field(type = FieldType.Text)
    private String PRODUCE_UNIT_NAME;

    @Field(type = FieldType.Text)
    private String INSPECT_REPORT;

    @Field(type = FieldType.Long)
    private Long NEXT_INSPECT_DATE;

    @Field(type = FieldType.Text)
    private String CONSTRUCTION_TYPE;

    @Field(type = FieldType.Text)
    private String USC_UNIT_CREDIT_CODE;

    @Field(type = FieldType.Text)
    private String USC_UNIT_NAME;

    @Field(type = FieldType.Text)
    private String USC_DATE;

    @Field(type = FieldType.Text)
    private String EQU_DEFINE;

    @Field(type = FieldType.Text)
    private String EQU_DEFINE_CODE;

    @Field(type = FieldType.Text)
    private String PRODUCT_NAME;

    @Field(type = FieldType.Text)
    private String BRAND_NAME;

    @Field(type = FieldType.Text)
    private String EQU_TYPE;

    @Field(type = FieldType.Text)
    private String PRODUCE_DATE;

    @Field(type = FieldType.Text)
    private String DATA_SOURCE;

    @Field(type = FieldType.Text)
    private String WHETHER_VEHICLE_CYLINDER;

    @Field(type = FieldType.Text)
    private String WHETHER_SKID_MOUNTED_PRESSURE_VESSEL;

    @Field(type = FieldType.Text)
    private String CYLINDER_CATEGORY;

    /**
     * 问题状态
     */
    @Field(type = FieldType.Text)
    private String problemStatus;

    /**
     * 是否纳管：true - 已纳管 false-未纳管
     */
    @Field(type = FieldType.Boolean)
    private Boolean IS_INTO_MANAGEMENT;

    /**
     * 设备使用地点区域码610000#610100#610101
     */
    @Field(type = FieldType.Keyword)
    private String USE_PLACE_CODE;

    /**
     * 设备使用场所代码-来源数据字典ADDRESS
     */
    @Field(type = FieldType.Keyword)
    private String USE_SITE_CODE;

    /**
     * 工程装置（工业管道使用）
     */
    @Field(type = FieldType.Keyword)
    private String PROJECT_CONTRAPTION;

    /**
     * 信息化
     */
    @Field(type = FieldType.Text)
    private String INFORMATION_SITUATION;

    /**
     * 工程装置id（工业管道使用）
     */
    @Field(type = FieldType.Keyword, name = "PROJECT_CONTRAPTION_ID")
    private String projectContraptionId;

    /**
     * 资料是否齐全（0齐全， 1不齐全）-西安数据导入
     */
    @Field(type = FieldType.Boolean, name = "IS_COMPLETE_XA")
    private Boolean IS_COMPLETE_XA;

    /**
     * 是否可以做业务-西安电梯导入用（false-否，true-是）
     */
    @Field(type = FieldType.Boolean, name = "IS_DO_BUSINESS")
    private Boolean IS_DO_BUSINESS;

    /**
     * 数据质量等级
     */
    @Field(type = FieldType.Integer, name = "DATA_QUALITY_SCORE")
    private Integer dataQualityScore;

    /**
     * 创建时间
     */
    @Field(type = FieldType.Long)
    private Long CREATE_DATE;

    /**
     * 标签
     */
    @Field(type = FieldType.Keyword)
    private String tag1;
}
