package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.transferNotice;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.common.biz.event.CommonPublisher;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.api.dto.PipelineChangeItemDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.biz.edit.event.BaseBizDataChangeEvent;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.DefaultBizDataChangeHandler;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 移转告知编辑处理器
 */
@Component
public class TransferNoticeDataChangeHandler extends DefaultBizDataChangeHandler<BaseBizDataChangeEvent> {

    private final TransferNoticeEditUpdateService transferNoticeEditUpdateService;

    protected TransferNoticeDataChangeHandler(CommonPublisher routerEventPublisher, ApplicationContext applicationContext, TransferNoticeEditUpdateService transferNoticeEditUpdateService) {
        super(routerEventPublisher, applicationContext);
        this.transferNoticeEditUpdateService = transferNoticeEditUpdateService;
    }

    @Override
    public String canHandleBizType() {
        return BusinessTypeEnum.JG_ADVICE_REMOVAL.name();
    }

    @Override
    public List<FieldChangeMeta> postSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData, List<FieldChangeMeta> allChangeColumns, Map<String, List<PipelineChangeItemDto>> pipelineChangeItemMap) {
        return Collections.emptyList();
    }

    @Override
    public Boolean beforeCheck(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {
        return Boolean.TRUE;
    }

    @Override
    public Set<String> getEqs(String applyNo) {
        return transferNoticeEditUpdateService.getEqsByApplyNo(applyNo);
    }

    /**
     * 管道专用
     * @param applyNo 单据号
     * 判断数据是实时落库，还是先存到json
     * @return 是否需要临时存储
     */
    @Override
    public Boolean requiresTemporarySave(String applyNo) {
        return false;
    }

    @Override
    public Boolean bizIsFinished(String applyNo) {
        JgTransferNotice jgTransferNotice = transferNoticeEditUpdateService.getTransferNoticeService().getOne(new LambdaQueryWrapper<JgTransferNotice>().eq(JgTransferNotice::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr, JgTransferNotice::getNoticeStatus));
        return jgTransferNotice.getNoticeStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
    }

    @Override
    public Set<String> getProjectContraptionIds(String applyNo) {
        return Collections.emptySet();
    }

    @Override
    public void preSave(String bizId, String applyNo, ModelType model, Map<String, Object> changeData) {

    }
}
