package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 八大类对应code枚举
 * @author LiuLin
 * @date 2024年01月03日 18:05
 */
@Getter
@AllArgsConstructor
public enum EquipCategoryEnum {
    // 锅炉
    IDX_BIZ_JG_TECH_PARAMS_BOILER(1000),
    // 压力容器
    IDX_BIZ_JG_TECH_PARAMS_VESSEL(2000),
    // 电梯
    IDX_BIZ_JG_TECH_PARAMS_ELEVATOR(3000),
    // 起重机械
    IDX_BIZ_JG_TECH_PARAMS_LIFTING(4000),
    // 场（厂）内专用机动车辆
    IDX_BIZ_JG_TECH_PARAMS_VEHICLE(5000),
    // 大型游乐设施
    IDX_BIZ_JG_TECH_PARAMS_RIDES(6000),
    // 压力管道
    IDX_BIZ_JG_TECH_PARAMS_PIPELINE(8000),
    // 客运索道
    IDX_BIZ_JG_TECH_PARAMS_ROPEWAY(9000);

    private final int equList;

    public static EquipCategoryEnum of(int equList) {
        for (EquipCategoryEnum ec : values()) {
            if (ec.equList == equList) {
                return ec;
            }
        }
        return null;
    }
}
