package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

@AllArgsConstructor
@Getter
public enum DocumentEnum {


    GZS("gzs", "告知书"),
    CPZL("cpzl", "产品质量证明书"),
    SGZX("sgzxbg", "施工自行检查报告"),
    SGHT("sght", "施工合同或证明"),
    SGFA("sgfa", "施工方案/施工设计文件"),
    SGDWXK("sgdwxk", "施工单位许可证书"),
    XSSY("xssy", "型式试验证书"),
    XSQTS("xsqts", "限速器和渐进式安全钳的调试证书"),
    TJSM("tjsm", "土建声明"),
    ZLBZ("zlbz", "质量保证手册和程序文件"),
    SGZY("sgzy", "施工作业文件"),
    SGRY("sgry", "施工人员、质量保证体系责任人、专业技术人员身份证、技术工人的身份证及资质证书"),
    SGSJ("sgsj", "施工设计文件"),
    SGFB("sgfb", "施工分包方目录"),
    FBSPJ("fbspj", "分包方评价资料"),
    QT("qtfj", "其他附件"),
    CPZLHGZ("cpzlhg", "产品质量合格证"),
    CPSJ("cpsj", "产品设计文件"),
    ZZXK("zzxk", "制造许可证"),
    ZJSY("zjsy", "安全保护装置的型式试验证书"),
    DDHL("ddhl", "电动葫芦的型式试验证书"),
    SYWH("sywh", "使用维护说明书"),
    CLXS("clxs", "车辆行驶线路图"),
    SYDJ("sydj", "使用登记证"),
    SYCJY("sycjy", "上一次检验报告"),
    FBHG("fbhg", "防爆合格证"),
    NDZXJC("ndzxjc", "年度自行检查报告"),
    AGGLRY("aqglry", "安全管理人员证"),
    ZYRYZ("zyry", "作业人员证"),
    WBHT("wbht", "维保合同"),
    AQBHZZ("aqbhzz", "安全保护装置的型式试验证书"),
    ZJHG("zjhg", "自检合格证明"),
    AZJY("azjy", "安装监检报告"),
    ZJCY("zjcy", "整机船运证明");

    private String code;
    private String name;

    public static List<String> getEnumNameList() {
        List<String> codeList = new ArrayList<String>();
        for (DocumentEnum c: DocumentEnum.values()) {
            codeList.add(c.getCode());
        }
        return codeList;
    }
    }
