package com.yeejoin.amos.boot.biz.common.bo;

import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/***
 *
 * 用户选择保存实体类
 * @author Dell
 * **/
public class ReginParams implements Serializable {
    private static final long serialVersionUID = 1L;
    private CompanyBo company;
    private RoleBo role;
    private DepartmentBo department;
    private AgencyUserModel userModel;
    private PersonIdentity personIdentity;
    private BusinessInfo businessInfo;

    @Data
    public static class PersonIdentity implements Serializable {
        private String identityType;
        private String personSeq;
        private String personName;
        private String companyId;
        private String companyName;
        private String bizOrgCode;
    }

    @Data
    public static class BusinessInfo implements Serializable {
        private Long amosBizCode; //平台企业code
        private String companyName; //公司名称
        private Long companySequenceNbr; //公司SequenceNbr（业务）
        private String companyType; //公司类型
        private Long amosUserCode;
        private String userName; //用户名称
        private Long userSequenceNbr; //用户sequenceNbr(业务)
        private String userType; //用户类型
    }

    public BusinessInfo getBusinessInfo() {
        return businessInfo;
    }

    public void setBusinessInfo(BusinessInfo businessInfo) {
        this.businessInfo = businessInfo;
    }

    public PersonIdentity getPersonIdentity() {
        return personIdentity;
    }

    public void setPersonIdentity(PersonIdentity personIdentity) {
        this.personIdentity = personIdentity;
    }

    @Deprecated
    private String token;

    public CompanyBo getCompany() {
        return company;
    }

    public void setCompany(CompanyBo company) {
        this.company = company;
    }

    public RoleBo getRole() {
        return role;
    }

    public void setRole(RoleBo role) {
        this.role = role;
    }

    public DepartmentBo getDepartment() {
        return department;
    }

    public void setDepartment(DepartmentBo department) {
        this.department = department;
    }

    public AgencyUserModel getUserModel() {
        return userModel;
    }

    public void setUserModel(AgencyUserModel userModel) {
        this.userModel = userModel;
    }

    @Deprecated
    public String getToken() {
        return token;
    }

    @Deprecated
    public void setToken(String token) {
        this.token = token;
    }
}
