package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.vo.VideoImportantEquipmentVo;
import com.yeejoin.equipmanage.service.IVideoImportantEquipmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ProjectName: amos-biz-boot
 * @Package: com.yeejoin.equipmanage.controller
 * @ClassName: VideoImportantEquipmentController
 * @Author: Jianqiang Gao
 * @Description: VideoImportantEquipmentController
 * @Date: 2022/6/16 10:24
 * @Version: 1.0
 */
@RestController
@Api(tags = "视屏监控关联重点设备Api")
@Slf4j
@RequestMapping(value = "/videoImportantEquipment", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class VideoImportantEquipmentController {

    @Autowired
    private IVideoImportantEquipmentService videoImportantEquipmentService;

    @RequestMapping(value = "/getVideoImportantEquipmentList", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "获取视屏监控关联重点设备集合", notes = "获取视屏监控关联重点设备集合")
    public List<VideoImportantEquipmentVo> getVideoImportantEquipmentList(@RequestParam(required = false) Long importantEquipmentId) {
        Map<String, Object> map = null;
        if (importantEquipmentId != null) {
            map = new HashMap<>();
            map.put("importantEquipmentId", importantEquipmentId);
        }
        return videoImportantEquipmentService.getVideoImportantEquipmentList(map);
    }
}