package com.yeejoin.precontrol.controller;

import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.PersonClock;
import com.yeejoin.precontrol.common.entity.publics.CommonPageable;
import com.yeejoin.precontrol.common.fileparser.utils.DateUtil;
import com.yeejoin.precontrol.common.service.IPersonClockService;
import com.yeejoin.precontrol.common.vo.PersonClockVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.HashMap;

/**
 * 人员履历信息(打卡)
 *
 * @author duanwei
 * @date 2020-06-30
 */
@RestController
@Api(tags = "人员履历信息(打卡)Api")
@RequestMapping(value = "/person-clock", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class PersonClockController {
	/**
	 * 用户打卡服务
	 */
	@Autowired
	IPersonClockService iPersonClockService;

	/**
	 * 新增人员履历信息(打卡)
	 *
	 * @return
	 */
	@RequestMapping(value = "/save", method = RequestMethod.POST)
	@ApiOperation(httpMethod = "POST", value = "新增人员履历信息(打卡)", notes = "新增人员履历信息(打卡)")
	public boolean savePersonClock(HttpServletRequest request, @RequestBody PersonClock personClock) {
		return iPersonClockService.save(personClock);
	}

	/**
	 * 根据id删除
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
	@ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
	public boolean deleteById(HttpServletRequest request, @PathVariable Long id) {
		return iPersonClockService.removeById(id);
	}

	/**
	 * 修改人员履历信息(打卡)
	 *
	 * @return
	 */
	@RequestMapping(value = "/updateById", method = RequestMethod.PUT)
	@ApiOperation(httpMethod = "PUT", value = "修改人员履历信息(打卡)", notes = "修改人员履历信息(打卡)")
	public boolean updateByIdPersonClock(HttpServletRequest request, @RequestBody PersonClock personClock) {
		return iPersonClockService.updateById(personClock);
	}

	/**
	 * 根据id查询
	 *
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
	public Object selectById(HttpServletRequest request, @PathVariable Long id) {
		return iPersonClockService.getById(id);
	}

	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "考勤列表分页查询", notes = "考勤列表分页查询")
	public Object listPage(CommonPageable pageable,
			@ApiParam("查询时间开始") @RequestParam(value = "clockTimeStart", required = false) String clockTimeStart,
			@ApiParam("查询时间结束") @RequestParam(value = "clockTimeEnd", required = false) String clockTimeEnd,
			@ApiParam("用户id") @RequestParam(value = "personId", required = true) Long personId) {
		HashMap<String, Object> param = new HashMap<>(2);
		param.put("clockTimeStart", clockTimeStart);
		param.put("clockTimeEnd", clockTimeEnd);
		param.put("personId", personId);
		return iPersonClockService.pageInfo(pageable, param);
	}

	/**
	 * 对接闸机生成数字签名
	 * 
	 * @param deviceNo
	 * @return ResponseModel
	 */
	@GetMapping("/signature")
	@ApiOperation(httpMethod = "GET", value = "对接闸机生成数字签名", notes = "对接闸机生成数字签名")
	public ResponseModel getSignature(@RequestParam("deviceNo") String deviceNo) {
		return iPersonClockService.getSignature(deviceNo);
	}

	/**
	 * 对接三合闸机人员出入场打卡
	 * 
	 * @param PersonClockVo
	 * @return ResponseModel
	 */
	@PostMapping("/clock")
	@ApiOperation(httpMethod = "POST", value = "三合闸机出入场回调接口", notes = "三合闸机出入场回调接口")
	public ResponseModel personClock(@RequestBody PersonClockVo PersonClockVo) {
		return iPersonClockService.personClock(PersonClockVo);
	}

	/**
	 * 开发接口
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/listByDevice", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "考勤列表分页查询", notes = "考勤列表分页查询")
	public Object listPage(StudioPageableDto pageable,PersonClockVo personClockVo ) {
		return iPersonClockService.listByDevice(pageable, personClockVo);
	}
	
	/**
	 * 列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list/notice", method = RequestMethod.GET)
	@ApiOperation(httpMethod = "GET", value = "考勤列表分页查询", notes = "考勤列表分页查询")
	public Object listNotice(CommonPageableDto pageable, PersonClockVo personClockVo,@DateTimeFormat(pattern="yyyy-MM")Date startMonth,@DateTimeFormat(pattern="yyyy-MM")Date endMonth) {
		return iPersonClockService.listNotice(pageable, personClockVo,startMonth,endMonth);
	}

}
