package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.mao.expertSystem.WeldingQualification;
import com.mao.expertSystem.material.MyPqr;
import com.mao.expertSystem.material.MyWps;
import com.yeejoin.amos.boot.biz.common.service.impl.WorkflowExcuteServiceImpl;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.common.biz.service.impl.OrgUsrServiceImpl;
import com.yeejoin.amos.boot.module.ugp.api.Enum.*;
import com.yeejoin.amos.boot.module.ugp.api.constants.XJConstant;
import com.yeejoin.amos.boot.module.ugp.api.dto.OverProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.dto.ProjectInitiationDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.*;
import com.yeejoin.amos.boot.module.ugp.api.mapper.ProjectInitiationMapper;
import com.yeejoin.amos.boot.module.ugp.api.service.IProcessRelationService;
import com.yeejoin.amos.boot.module.ugp.api.service.IProjectInitiationService;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.type.LocalDateTypeHandler;
import org.joda.time.LocalDateTime;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.utils.DateUtil;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import javax.annotation.Resource;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.*;

@Service
@Slf4j
public class ProjectInitiationServiceImpl extends BaseService<ProjectInitiationDto, ProjectInitiation, ProjectInitiationMapper> implements IProjectInitiationService {

    @Autowired
    SuperviseRuleServiceImpl superviseRuleService;

    @Autowired
    ProjectInitiationServiceImpl projectInitiationService;

    @Autowired
    WorkflowExcuteServiceImpl workflowExcuteService;

    @Autowired
    InstallNoticeMsgServiceImpl installNoticeMsgService;

    @Autowired
    ProjectServiceImpl projectServiceImpl;

    @Autowired
    SuperviseRuleServiceImpl superviseRuleServiceImpl;

    @Autowired
    ProjectServiceImpl projectService;

    @Autowired
    OrgUsrServiceImpl orgUsrServiceImpl;

    @Autowired
    RectifyMsgServiceImpl rectifyMsgServiceImpl;

    @Autowired
    ProblemInitiationServiceImpl problemInitiationService;

    @Autowired
    private TaskServiceImpl taskService;

    private final Logger logger = LoggerFactory.getLogger(ProjectInitiationServiceImpl.class);

    @Value("${params.work.flow.processDefinitionKey}")
    private String processDefinitionKey;

    /**
     * 竣工结项流程key
     */
    @Value("${params.work.flow.completedProjectDefinitionKey:jungongjiexiangliucheng}")
    private String completedProjectDefinitionKey;


    @Resource
    private IProcessRelationService processRelationService;

    /**
     * 测试流程使用
     * @param project
     * @return
     */
    public String startTest(Project project) {
        String instanceId = null;
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(processDefinitionKey);
            dto.setBusinessKey("1");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("流程启动失败："+e.getMessage());
        }
        return instanceId;
    }

    /**
     * 测试流程使用
     * @param instanceId
     * @return
     */
    public void getTaskList(String instanceId){
        JSONObject dataObject = new JSONObject();
        JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(Workflow.taskClient.getTaskList(instanceId)));
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        for(Object o:jsonArray){
            String name = JSONObject.parseObject(JSON.toJSONString(o)).getString("name");
            if(ProjectInitiationEnum.安装开工资料修改.getName().equals(name)){
                dataObject = JSONObject.parseObject(JSON.toJSONString(o));
            }
        }
        Workflow.taskClient.getTaskList(instanceId);
        Workflow.taskClient.getTasksNoAuth(processDefinitionKey,null);
        Workflow.taskClient.getTask(instanceId);
    }

    /**
     * 测试流程使用
     * @param instanceId
     * @param condition
     * @param option
     * @return
     */
    public String executeTest(String instanceId, String condition,String option){
        AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
        JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskName = dataObject.getString("name");
        String taskId = dataObject.getString("id");
        String str = "当前任务节点："+taskName+"，任务id："+taskId;
        try {
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResult(condition);
            dto.setResultCode("condition");
            dto.setTaskId(taskId);
            HashMap<String, Object> var = new HashMap<>();
            var.put("condition", condition);
            var.put("option", option);
            dto.setVariable(var);
            Workflow.taskClient.completeByTask(taskId, dto);
            str = str +"   执行成功！";
        } catch (Exception e) {
            str = str + "   执行失败";
        }
        return str;
    }

    @Override
    public void start(Project project) {
        System.out.println("流程启动："+DateUtils.date2LongStr(new Date()));
        String instanceId = null;
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(processDefinitionKey);
            dto.setBusinessKey("1");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map)ajaxResult.get("data")).get("id").toString();
            ProjectInitiation projectInitiation = new ProjectInitiation();
            projectInitiation.setInstanceId(instanceId);
            projectInitiation.setTaskName("流程启动！");
            this.save(projectInitiation);
        } catch (Exception e) {
            e.printStackTrace();
            System.out.println("流程启动失败："+e.getMessage());
        }
        String taskName = null;
        try {
            taskName = getFlowTaskName(instanceId);
        } catch (Exception e) {
            e.printStackTrace();
        }
        project.setInstanceId(instanceId);
        project.setStatus(taskName);
        projectService.updateById(project);
        //新增流程关系表的流程id和流程状态及资源id
        processRelationService.savePR(instanceId,project.getSequenceNbr(),ProcessTypeEnum.项目立项.getName());
        //执行项目立项流程
        execute(instanceId,project,null,null);
    }

    @Override
    public void execute(String instanceId,Object objectd, String condition,String option){
        String taskType = "";
        List<Long> unitIds = new ArrayList<>();
        Long extendId = -1L;
        String taskName = "";

        JSONObject object = JSONObject.parseObject(JSONObject.toJSONString(objectd));
        Project project = JSON.parseObject(JSONObject.toJSONString(objectd),Project.class);
        if(ValidationUtil.isEmpty(project.getName())){
            project = projectService.getById(object.getLong("projectId"));
        }
        AjaxResult ajaxResult = new AjaxResult();
        JSONObject dataObject = new JSONObject();
        try {
            ajaxResult = Workflow.taskClient.getTask(instanceId);
            dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        }catch (Exception e) {
            //当存在多个用户任务时 主要是安装/设计提交资料修改
            logger.error("当前用户存在多个任务");
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(Workflow.taskClient.getTaskList(instanceId)));
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            for(Object o:jsonArray){
                String name = JSONObject.parseObject(JSON.toJSONString(o)).getString("name");
                if(ProjectInitiationEnum.安装开工资料修改.getName().equals(name)){
                    dataObject = JSONObject.parseObject(JSON.toJSONString(o));
                }
            }
        }

        taskName = dataObject.getString("name");
        ProjectInitiation projectInitiation = new ProjectInitiation();
        projectInitiation.setInstanceId(instanceId);
        //将所要的数据存为context格式
        projectInitiation.setContext(JSON.toJSONString(objectd));
        projectInitiation.setTaskId(dataObject.getString("id"));
        projectInitiation.setTaskName(taskName);
        projectInitiation.setType(ProcessTypeEnum.项目立项.getType());

        //项目的管辖区域
        String regionCode = project.getInstallRegionCode();
        LambdaQueryWrapper<SuperviseRule> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(SuperviseRule :: getAdminRegionCode,regionCode);
        SuperviseRule superviseRule = superviseRuleService.getOne(wrapper);
        if (ProjectInitiationEnum.告知申请.getName().equals(taskName)) {
            if(!ValidationUtil.isEmpty(objectd)) {
                problemInitiationService.sendSms(object, SMSEnum.项目安装告知申请.getCode());
            }
        }
        if (ProjectInitiationEnum.告知申请.getName().equals(taskName) || ProjectInitiationEnum.接受告知.getName().equals(taskName) ) {
            extendId = object.getLong("sequenceNbr");
        }
        if(ProjectInitiationEnum.监检员审核.getName().equals(taskName)){
            if("1".equals(option)){
                projectInitiation.setTaskName(taskName+"（流程结束！）");
            }
        }

        try {
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResult(option);
            dto.setResultCode("condition");
            dto.setTaskId(projectInitiation.getTaskId());
            HashMap<String, Object> var = new HashMap<>();
            var.put("condition", option);
            dto.setVariable(var);
            //执行流程
            Workflow.taskClient.completeByTask(projectInitiation.getTaskId(),dto);
            //保存日志
            this.save(projectInitiation);

            //更新任务表的状态 已办
            taskType = getUnitId(unitIds, project, superviseRule);
            taskService.saveOrUpdateTask(project.getStatus(), true, taskType, new Date(), project.getSequenceNbr(), TaskTypeEnum.项目立项.getKey(), unitIds,extendId);

            //更新project种的status字段,更新关系表中的state字段，表示当前流程下一个执行的任务
            boolean bool = updateFlowStatus(instanceId);

            //如果更新了status状态 新增任务表的状态 待办
            if(bool) {
                project = projectService.getById(object.getLong("sequenceNbr"));
                if (ValidationUtil.isEmpty(project)) {
                    project = projectService.getById(object.getLong("projectId"));
                }
                unitIds = new ArrayList<>();
                taskType = getUnitId(unitIds, project, superviseRule);
                taskService.saveOrUpdateTask(project.getStatus(), false, taskType, new Date(), project.getSequenceNbr(), TaskTypeEnum.项目立项.getKey(), unitIds, extendId);
                System.out.println("流程更新任务表结束：" + DateUtils.date2LongStr(new Date()));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取任务的执行单位id 和 TaskType
     * @param unitIds
     */
    public String getUnitId(List<Long> unitIds,Project project,SuperviseRule superviseRule){
        String taskType = "";
        if (ProjectInitiationEnum.项目立项.getName().equals(project.getStatus())) {
            unitIds.add(project.getConstructionUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if (ProjectInitiationEnum.告知申请.getName().equals(project.getStatus())) {
            unitIds.add(project.getInstallationUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if (ProjectInitiationEnum.接受告知.getName().equals(project.getStatus())) {
            unitIds.add(superviseRule.getSuperviseDeptId());
            taskType = TaskTypeEnum.流程.getKey();
        }
        if (ProjectInitiationEnum.监检员分配.getName().equals(project.getStatus()) || ProjectInitiationEnum.监检员审核.getName().equals(project.getStatus()) || ProjectInitiationEnum.监检科室分配.getName().equals(project.getStatus())) {
            unitIds.add(superviseRule.getInspectionUnitId());
            taskType = TaskTypeEnum.流程.getKey();
        }
        if (ProjectInitiationEnum.提交资料.getName().equals(project.getStatus()) ) {
            unitIds.add(project.getInstallationUnitId());
            unitIds.add(project.getDesignUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if(ProjectInitiationEnum.安装开工资料修改.getName().equals(project.getStatus())){
            unitIds.add(project.getInstallationUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if(ProjectInitiationEnum.设计开工资料修改.getName().equals(project.getStatus())){
            unitIds.add(project.getDesignUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if (ProjectInitiationEnum.修改资料.getName().equals(project.getStatus()) ) {
            unitIds.add(project.getInstallationUnitId());
            unitIds.add(project.getDesignUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if (OverProjectFlowEnum.上传竣工资料.getName().equals(project.getStatus())) {
            unitIds.add(project.getConstructionUnitId());
            taskType = TaskTypeEnum.填报.getKey();
        }
        if (OverProjectFlowEnum.竣工资料审核并填写审核意见.getName().equals(project.getStatus()) || OverProjectFlowEnum.竣工资料上传确认.getName().equals(project.getStatus())) {
            unitIds.add(superviseRule.getSuperviseDeptId());
            taskType = TaskTypeEnum.流程.getKey();
        }
        return taskType;
    }


    /*焊评审核(后期优化)
     * @return
     */
    public String evaluateMethod(String sequenceNbr,JSONObject json) {

        //获取文档信息(2个文档 wps pqr)
        JSONArray subForm = json.getJSONArray("subForm");
        JSONObject jsonObject1 = subForm.getJSONObject(0);
        JSONArray info = jsonObject1.getJSONArray("info");
        //info里面上传两个文档
        JSONObject js1 = info.getJSONObject(0);
        JSONObject js2 = info.getJSONObject(1);
        String name1 = js1.getString("name");
        String url1 = js1.getString("url");
        String name2 = js1.getString("name");
        String url2 = js2.getString("url");
        //文档下载,调用python 文字识别

        //识别结果,将结果放到pqr wps



        MyPqr pqr = new MyPqr( );
        MyWps wps = new MyWps( );
        pqr.setWelding_method(json.getString("pqr_welding_method"));
        pqr.setMaterial_a_number(json.getString("pqr_material_a_number"));
        pqr.setMaterial_a_class(json.getString("pqr_material_a_class"));
        pqr.setMaterial_a_thickness(json.getDouble("pqr_material_a_thickness"));
        pqr.setMaterial_a_group(json.getString("pqr_material_a_group"));
        pqr.setMaterial_a_standard(json.getString("pqr_material_a_standard"));
        pqr.setMaterial_b_number(json.getString("pqr_material_b_number"));
        pqr.setMaterial_b_class(json.getString("pqr_material_b_class"));
        pqr.setMaterial_b_thickness(json.getDouble("pqr_material_b_thickness"));
        pqr.setMaterial_b_group(json.getString("pqr_material_b_group"));
        pqr.setMaterial_b_standard(json.getString("pqr_material_b_standard"));
        pqr.setIf_shock(json.getString("pqr_if_shock"));
        pqr.setIf_bend(json.getString("pqr_if_bend"));
        pqr.setGtaw_weld_material_class(json.getString("pqr_gtaw_weld_material_class"));
        pqr.setSmaw_weld_material_class(json.getString("pqr_smaw_weld_material_class"));
        pqr.setSaw_weld_material_class_1(json.getString("pqr_saw_weld_material_class_1"));
        pqr.setSaw_weld_material_class_2(json.getString("pqr_saw_weld_material_class_2"));
        pqr.setGmaw_weld_material_class(json.getString("pqr_gmaw_weld_material_class"));
        pqr.setIf_heat_treatment(json.getString("pqr_if_heat_treatment"));
        pqr.setTemperature(json.getDouble("pqr_temperature"));
        pqr.setCombox_type(json.getString("pqr_combox_type"));
        pqr.setTemperature_time(json.getDouble("pqr_temperature_time"));
        pqr.setMaterial_minT_of_a_b_thickness(json.getDouble("pqr_material_minT_of_a_b_thickness"));



        wps.setWelding_method(json.getString("wps_welding_method"));
        wps.setMaterial_a_number(json.getString("wps_material_a_number"));
        wps.setMaterial_a_class(json.getString("wps_material_a_class"));
        wps.setMaterial_a_thickness(json.getDouble("wps_material_a_thickness"));
        wps.setMaterial_a_group(json.getString("wps_material_a_group"));
        wps.setMaterial_a_standard(json.getString("wps_material_a_standard"));
        wps.setMaterial_b_number(json.getString("wps_material_b_number"));
        wps.setMaterial_b_class(json.getString("wps_material_b_class"));
        wps.setMaterial_b_thickness(json.getDouble("wps_material_b_thickness"));
        wps.setMaterial_b_group(json.getString("wps_material_b_group"));
        wps.setMaterial_b_standard(json.getString("wps_material_b_standard"));
        wps.setIf_shock(json.getString("wps_if_shock"));
        wps.setIf_bend(json.getString("wps_if_bend"));
        wps.setGtaw_weld_material_class(json.getString("wps_gtaw_weld_material_class"));
        wps.setSmaw_weld_material_class(json.getString("wps_smaw_weld_material_class"));
        wps.setSaw_weld_material_class_1(json.getString("wps_saw_weld_material_class_1"));
        wps.setSaw_weld_material_class_2(json.getString("wps_saw_weld_material_class_2"));
        wps.setGmaw_weld_material_class(json.getString("wps_gmaw_weld_material_class"));
        wps.setIf_heat_treatment(json.getString("wps_if_heat_treatment"));
        wps.setTemperature(json.getDouble("wps_temperature"));
        wps.setCombox_type(json.getString("wps_combox_type"));
        wps.setTemperature_time(json.getDouble("wps_temperature_time"));
        wps.setMaterial_minT_of_a_b_thickness(json.getDouble("wps_material_minT_of_a_b_thickness"));

        HashMap<String, String> stringStringHashMap = new WeldingQualification( ).equipmentWeldingQualification(pqr, wps);


        //结果(假设)
       String reslut =AuditEnum.符合.getName();

        String option =AuditEnum.getNameByStatus.get(reslut);
        Project project = projectServiceImpl.getById(sequenceNbr);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(project));
        jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,AuditEnum.符合.getName());
        if(AuditEnum.不符合且不需要整改.getStatus().equals(option)){
            jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,AuditEnum.不符合且不需要整改.getName());
            projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
            projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
        }else if(AuditEnum.不符合且需要重新提交资料.getStatus().equals(option)){
            jsonObject.put(XJConstant.PROCESS_PROJECT_STATE,AuditEnum.不符合且需要重新提交资料.getName());
        }
        projectInitiationService.execute(project.getInstanceId(),jsonObject,option,null);
        return stringStringHashMap.toString();
    }



    /**
     * 获取流程当前任务名称
     * @param instanceId
     * @return
     */
    public String getFlowTaskName(String instanceId){
        AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskName = "流程结束！";
        try {
            taskName=jsonObject.getString("name");
        }catch (Exception e) {}
        return taskName;
    }

    public boolean updateFlowStatus(String instanceId){
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Project::getInstanceId,instanceId);
        Project project = projectService.getOne(wrapper);
        String taskName = getFlowTaskName(instanceId);
        boolean bool = true;
        if(project.getStatus().equals(ProjectInitiationEnum.提交资料.getName())){
            if("流程结束！".equals(taskName)){
                bool = false;
            }
        }
        if(bool) {
            project.setStatus(taskName);
            projectService.updateById(project);
            processRelationService.updateState(instanceId,taskName);
        }
        return bool;
    }

    public void updateProjectFlowStatus(String instanceId){
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Project::getInstanceId,instanceId);
        Project project = projectService.getOne(wrapper);
//        project.setStatus(ProjectInitiationEnum.getCodeByNameMap.get(getFlowTaskName(instanceId)));
        project.setStatus(getFlowTaskName(instanceId));
        projectService.updateById(project);
    }


    @Override
    public void overProjectFlowStart(OverProjectDto overProjectDto) {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey(completedProjectDefinitionKey);
            dto.setBusinessKey("1");
            HashMap<String, Object> dtoMap = new HashMap<>();
            dtoMap.put("condition", overProjectDto.getCondition());
            dto.setVariables(dtoMap);
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
            //修改project表的流程状态
            Project project = projectService.getById(overProjectDto.getProjectId());
            project.setInstanceId(instanceId);
            project.setStatus(getFlowTaskName(instanceId));
            projectService.updateById(project);
            processRelationService.savePR(instanceId, project.getSequenceNbr(), ProcessTypeEnum.项目结项.getName());
            ProjectInitiation projectInitiation = new ProjectInitiation();
            projectInitiation.setInstanceId(instanceId);
            projectInitiation.setTaskName("流程启动！");
            projectInitiationService.save(projectInitiation);
        } catch (Exception e) {
            e.printStackTrace();
            log.info("流程启动失败：{}", e.getMessage());
        }
        //执行项目竣工结项流程
        overProjectDto.setInstanceId(instanceId);
        overProjectFlowExecute(overProjectDto);
    }

    @Override
    public void overProjectFlowExecute(OverProjectDto overProjectDto) {
        String taskType = "";
        List<Long> unitIds = new ArrayList<>();
        Long extendId = -1L;
        try {
            AjaxResult ajaxResult = Workflow.taskClient.getTask(overProjectDto.getInstanceId());
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
            LambdaQueryWrapper<ProjectInitiation> wrapper = new LambdaQueryWrapper<>();
            wrapper.eq(ProjectInitiation::getInstanceId, overProjectDto.getInstanceId());
            wrapper.eq(ProjectInitiation::getTaskId, taskId);
            wrapper.eq(ProjectInitiation::getType, ProcessTypeEnum.项目结项.getType());
            ProjectInitiation one = projectInitiationService.getOne(wrapper);
            if (!ObjectUtils.isEmpty(one)) {
                //将所要的数据存为context格式
                one.setContext(JSON.toJSONString(overProjectDto));
                projectInitiationService.updateById(one);
            } else {
                ProjectInitiation projectInitiation = new ProjectInitiation();
                //如果不是保存，走工作流； 如果只是保存，只需要保存业务数据
                projectInitiation.setInstanceId(overProjectDto.getInstanceId());
                //将所要的数据存为context格式
                projectInitiation.setContext(JSON.toJSONString(overProjectDto));
                projectInitiation.setTaskId(taskId);
                projectInitiation.setTaskName(dataObject.getString("name"));
                projectInitiation.setType(ProcessTypeEnum.项目结项.getType());
                projectInitiationService.save(projectInitiation);
            }
            if (!WhetherItPassEnum.SAVE.getCode().equals(overProjectDto.getCondition())) {
                //组装信息
                TaskResultDTO dto = new TaskResultDTO();
                dto.setResult(overProjectDto.getCondition());
                dto.setResultCode("condition");
                dto.setTaskId(taskId);
                //执行流程
                Workflow.taskClient.completeByTask(taskId, dto);
                processRelationService.updateState(overProjectDto.getInstanceId(),null);
                //项目的管辖区域
                Project project = projectService.getById(overProjectDto.getProjectId());
                String regionCode = project.getInstallRegionCode();
                LambdaQueryWrapper<SuperviseRule> wrapperSR = new LambdaQueryWrapper<>();
                wrapperSR.eq(SuperviseRule :: getAdminRegionCode,regionCode);
                SuperviseRule superviseRule = superviseRuleService.getOne(wrapperSR);
                //更新任务表的状态 已办
                taskType = getUnitId(unitIds, project, superviseRule);
                taskService.saveOrUpdateTask(project.getStatus(), true, taskType, new Date(), project.getSequenceNbr(), TaskTypeEnum.项目结项.getKey(), unitIds,null);

                //更新project种的status字段，表示当前流程下一个执行的任务
                Project projectNext = updateProjectFlowStatusReturnObject(overProjectDto.getInstanceId());

                //新增任务表的状态 待办
                unitIds = new ArrayList<>();
                taskType = getUnitId(unitIds, projectNext, superviseRule);
                taskService.saveOrUpdateTask(projectNext.getStatus(), false, taskType, new Date(), projectNext.getSequenceNbr(), TaskTypeEnum.项目结项.getKey(), unitIds,extendId);
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("竣工结项流程执行失败：{}", e.getMessage());
        }
    }


    /**
     * //更新project种的status字段，表示当前流程下一个执行的任务
     * @param instanceId 实例ID
     * @return 修改后的项目信息
     */
    public Project updateProjectFlowStatusReturnObject(String instanceId){
        LambdaQueryWrapper<Project> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(Project::getInstanceId,instanceId);
        Project project = projectService.getOne(wrapper);
        project.setStatus(getFlowTaskName(instanceId));
        projectService.updateById(project);
        return project;
    }

}
