package com.yeejoin.amos.boot.module.common.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.DynamicFormInstanceDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;
import org.apache.ibatis.annotations.Param;

import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 动态表单实例表 Mapper 接口
 *
 * @author system_generator
 * @date 2021-07-06
 */
public interface DynamicFormInstanceMapper extends BaseMapper<DynamicFormInstance> {

    public List<DynamicFormInstanceDto> selectListByCalledId(Long id);

    public List<DynamicFormInstanceDto> listBySeqnum(Long id);

    /**
     * 列转行查询
     *
     * @param appKey     应用标识
     * @param fieldCodes 列
     * @param groupCode  分组code
     * @param params     查询参数map
     * @return List<Map>
     */
    List<Map<String, Object>> listAll(
            @Param("appKey") String appKey,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params
    );


    List<Map<String, Object>> listOnDutyPersonByAid(
            @Param("dutyDate") String dutyDay,
            @Param("shiftId") String shiftIds,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode);


    /**
     * 分页查询
     *
     * @param page       分页信息
     * @param appKey     应用
     * @param fieldCodes 字段
     * @param groupCode  表单类型
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> pageList(
            Page<Map<String, Object>> page,
            @Param("appKey") String appKey,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params
    );

    /**
     * 查询指定日期的值班信息
     * @param dutyDay    值班日期
     * @param shiftId    班次id
     * @param fieldCodes 动态列
     * @param appKey     应用标识
     * @param groupCode 表单类型
     * @param params 查询条件
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> listOneDayDutyPerson(
            @Param("dutyDate") String dutyDay,
            @Param("shiftId") Long shiftId,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("appKey") String appKey,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params);

    /**
     * 查询当前值班信息
     * @param dutyDay    值班日期
     * @param shiftIds    班次id
     * @param fieldCodes 动态列
     * @param groupCode 表单类型
     * @return List<Map < String, Object>>
     */
    List<Map<String, Object>> listOnDutyPerson(
            @Param("dutyDate") String dutyDay,
            @Param("shiftId") String shiftIds,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode);

    List<DynamicFormInstance> getInstanceByCodeAndValue(String code, String value);

    /**
     * 新分页查询带日期过滤// 不存在值班数据则不查找 修改sql 方法去除 by kongfm 2021-09-14
     *
     * @param page       分页信息
     * @param appKey     应用
     * @param fieldCodes 字段
     * @param groupCode  表单类型
     * @return IPage<Map < String, Object>>
     */
    IPage<Map<String, Object>> pageListNew(
            Page<Map<String, Object>> page,
            @Param("appKey") String appKey,
            @Param("fieldCodes") Map<String, Object> fieldCodes,
            @Param("groupCode") String groupCode,
            @Param("params") Map<String, String> params,
            @Param("stratTime") String stratTime,
            @Param("endTime") String endTime
    );
    
   /**
    * 值班表中 【值班排班】中特定部门的特定日期值班员；
    * @param dutyDate
    * @param departmentName eg：急救科、消救部
    * @return
    */
    
    List<Map<String, Object>>  getDutyPersonByTeamIdAndCarId(
    		String dutyDate,
    		String departmentName);
    /**
     * 值班表中 【120急救排班】该急救站的当日值班员
     * @param dutyDate
     * @param firstAidId
     * @return
     */
    List<Map<String, Object>>  getDutyPersonByTeamIdAndAirId(
    		String dutyDate,
    		String firstAidId);
/**
 *   机场单位的人员中，部门 ”人员职务“ 不为空的人员，不包括下级部门的人员
 * @param departmentName eg: 急救科、 消救部
 * @param PositionType : eg 岗位为：支队长、副支队长、党支部副书记、支队长助理、指挥员、；
 * @return
 */
    List<Map<String, Object>> getFireRescueDepartmentStaff(String departmentName,List<String> positionType);
    
    
    List<Map<String, Object>>   getDutyFirePerson(String dutyDate,String groupCode);
    
    Map<String, Object>  getCurentCarIsUserPhone(long carId);
    
    List<Map<String, Object>>    getOrgPersonTelphone(List<Map<String, Object>> companyIds);

    List<Map<String, Object>> personInfoList(String groupCode, HashSet<String> userIdSet);

    /**
     * 查询运维人员
     * @param page
     * @return
     */
    Page<Map<String, Object>> getPersonInfoByPage(Page<Map<String, Object>> page, @Param("bizOrgCode") String bizOrgCode);
    List<Map<String, Object>> dutyCardCount();

    List<Map<String, Object>> dutyCardList ();
}


