package com.yeejoin.amos.patrol.dao.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 * 基本实体类
 * </pre>
 *
 */

@MappedSuperclass

@EntityListeners(AuditingEntityListener.class)
@Data
public class BasicEntity implements Serializable{

	private static final long serialVersionUID = -5464322936854328207L;
	
	/**
	 * id
	 */
	private long id;

	@CreatedDate
	@Column(name="create_date")
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date createDate;

	@Id
    @GeneratedValue(generator = "myIdGeneratorConfig",
            strategy = GenerationType.AUTO)
    @GenericGenerator(
            name = "myIdGeneratorConfig",
            strategy = "com.yeejoin.amos.patrol.core.common.request.MyIdGeneratorConfig")
	@Column(name = "ID",nullable=false,unique=true)
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getCreateDate() {
		return createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	
	


	

}
