package com.yeejoin.equipmanage.fegin;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.equipmanage.common.entity.publics.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;


/**
 * @author DELL
 */
@FeignClient(name = "${idx.feign.name}", path = "idx", configuration = {FeignConfiguration.class})
public interface IdxFeign {

    /***
     * <pre>
     * @Description: 根据告警id查询缺陷治理情况
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2022/9/27 17:46
     */
    @RequestMapping(value = "/defect/alarm/{alarmLogId}", method = RequestMethod.GET)
    ResponseModel<JSONObject> queryDefectByBatchId(@PathVariable(value = "alarmLogId") String alarmLogId);

    @RequestMapping(value = "/defect/check/list", method = RequestMethod.POST)
    JSONObject queryDefectByCodes(@RequestBody(required = false) List<String> codes, @RequestParam String checkId);

    @RequestMapping(value = "/qrcode/scrap/expired/put", method = RequestMethod.GET)
    ResponseModel<JSONObject> handleEquipNotScrapWhenExpired(@RequestParam("equipId") String equipId,
                                                             @RequestParam("bizOrgCode") String bizOrgCode,
                                                             @RequestParam("bizOrgCode") String bizOrgName);

}
