package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.amos.boot.biz.common.dto.OrgMenuDto;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.equipmanage.common.dto.OrgUsrDto;
import com.yeejoin.equipmanage.fegin.JcsFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author DELL
 */
@Service
public class JCSRemoteService {

    @Autowired
    JcsFeign jcsFeignClient;

    /**
     * 公司部门树
     * @param authKey 权限key
     * @param orgType 树类型null,公司部门树，COMPANY: 公司树 DEPARTMENT部门树
     * @return List<OrgMenuDto>
     */
    public List<OrgMenuDto> getCompanyDeptTreeWithAuth(String authKey, String orgType) {
        FeignClientResult<List<OrgMenuDto>> feignClientResult = jcsFeignClient.getCompanyDeptTreeWithAuth(authKey, orgType);
        return feignClientResult.getResult();
    }

    /**
     *
     * 查询有权限的公司部门列表
     * @param authKey          权限key
     * @param orgTypes(多个逗号分隔) 为空默认查询公司和部门，COMPANY: 公司树 DEPARTMENT部门树
     * @return List<OrgUsrDto>
     */
    public List<OrgUsrDto> getCompanyDeptListWithAuth(String authKey, String orgTypes,String type) {
        FeignClientResult<List<OrgUsrDto>> feignClientResult = jcsFeignClient.getCompanyDeptListWithAuth(authKey, orgTypes, type);
        return feignClientResult.getResult();
    }

    /**
     *
     * 查询无权限的公司部门列表
     *
     * @param orgTypes(多个逗号分隔) 为空默认查询公司和部门，COMPANY: 公司树 DEPARTMENT部门树
     * @return List<OrgUsrDto>
     */
    public List<OrgUsrDto> getlistCompanyTree( String orgType) {
        FeignClientResult<List<OrgUsrDto>> feignClientResult = jcsFeignClient.getlistCompanyTree( orgType);
        return feignClientResult.getResult();
    }

    public String getCompany(String bizOrgCode) {
        FeignClientResult<String> feignClientResult = jcsFeignClient.getCompany(bizOrgCode);
        return feignClientResult.getResult();
    }
}
