package com.yeejoin.amos.patrol.business.feign;

import com.yeejoin.amos.component.feign.model.FeignClientResult;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;


/**
 * @author DELL
 */
@FeignClient(name = "${idx.feign.name}", path = "idx", configuration = {FeignConfiguration.class})
public interface IdxFeign {

    /***
     * <pre>
     * @Description: 根据巡检转缺陷code查询缺陷列表
     * </pre>
     *
     * @MethodName:
     * @Param:
     * @Return: null
     * @Throws
     * @Author keyong
     * @Date 2023/04/22 17:46
     */
    @PostMapping(value = "/defect/check/list")
    FeignClientResult queryDefectByCodes(@RequestBody List<String> codes, @RequestParam String checkId);

}
