package com.yeejoin.amos.boot.module.tzs.api.mapper;

import com.yeejoin.amos.boot.module.tzs.api.dto.AlertCalledQueryDto;
import com.yeejoin.amos.boot.module.tzs.api.entity.AlertCalled;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 警情接警填报记录 Mapper 接口
 *
 * @author litw
 * @date 2021-08-03
 */
public interface AlertCalledMapper extends BaseMapper<AlertCalled> {

    /**
     * 接警情况统计
     *
     * @param beginDate
     * @param endDate
     * @return
     */
    Map<String, Integer> queryAlertStatusCount(@Param("beginDate") String beginDate,
                                               @Param("endDate") String endDate,
                                               @Param("orgCode") String orgCode,
                                               @Param("recUserId") String recUserId
                                               );

    /**
     * 根据查询条件返回警情记录
     * @param alertCalledQueryDto
     * @return
     */
    List<AlertCalledQueryDto> queryAlertListByQueryDto(@Param("alertCalledQueryDto") AlertCalledQueryDto alertCalledQueryDto);
}
