package com.yeejoin.amos.boot.module.common.biz.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.module.common.api.dto.FailureStatusCountDto;
import com.yeejoin.amos.boot.module.common.biz.constats.Constants;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureDetails;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FailureDetailsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 *
 * @author system_generator
 * @date 2021-08-04
 */
@RestController
@Api(tags = "故障维修单Api")
@RequestMapping(value = "/common/failure-details")
public class FailureDetailsController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(FailureDetailsServiceImpl.class);

    @Autowired
    FailureDetailsServiceImpl failureDetailsServiceImpl;

    /**
     * 新增
     *
     * @return
     * @throws Exception 
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
	public ResponseModel<Object> save(@RequestBody FailureDetailsDto model )  {
	  	Object result;
		try {
			result = failureDetailsServiceImpl.savemodel(model,getSelectedOrgInfo());
			 return ResponseHelper.buildResponse(result);
		} catch (Exception e) {
			e.printStackTrace();
			// TODO Auto-generated catch block
			 return ResponseHelper.buildResponse("error");
		}
	}


	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
	public ResponseModel<FailureDetailsDto> updateBySequenceNbrFailureDetails(@RequestBody FailureDetailsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(failureDetailsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个",  notes = "根据sequenceNbr查询单个")
	public ResponseModel<FailureDetailsDto> selectOne(@PathVariable Long sequenceNbr) {

	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForOne(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "分页查询",  notes = "分页查询")
	public ResponseModel<IPage<FailureDetailsDto>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
                    (value = "size") int size, @RequestParam Integer type) {
	    Page<FailureDetails> page = new Page<FailureDetails>();
	    page.setCurrent(current);
	    page.setSize(size);
		final AgencyUserModel userInfo = getUserInfo();
		IPage<FailureDetailsDto> failureDetailDTOsIPage = new Page<>();
		IPage<FailureDetails> failureDetailsIPage = failureDetailsServiceImpl.queryForFailureDetailsPage(page, userInfo, type);
		BeanUtils.copyProperties(failureDetailsIPage,FailureDetailsDto.class);
		List<FailureDetails> records = failureDetailsIPage.getRecords();
		List<FailureDetailsDto> failureDetailsDtoList = new ArrayList<>();
		records.forEach(failureDetails -> {
			FailureDetailsDto failureDetailsDto = new FailureDetailsDto();
			BeanUtils.copyProperties(failureDetails,failureDetailsDto);

			failureDetailsDto.setCurrentStatusName(
					Constants.currentStatusNameMap.get(failureDetails.getCurrentStatus()));
			failureDetailsDtoList.add(failureDetailsDto);
		});
		failureDetailDTOsIPage.setRecords(failureDetailsDtoList);

		return ResponseHelper.buildResponse(failureDetailDTOsIPage);
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "列表全部数据查询",   notes = "列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<FailureDetailsDto>> selectForList() {
	    return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForFailureDetailsList());
	}

	/**
	 * 根据状态查询当前下全部数据
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "根据状态查询当前下全部数据",   notes = "根据状态查询当前下全部数据")
	@GetMapping(value = "/list/{currentStatus}")
	public ResponseModel<List<FailureDetails>> selectStatusForList(@PathVariable Long currentStatus) {

		return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryForFailureStatus(currentStatus));
	}

	/**
	 * 查询当前状态任务数量
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "查询当前状态任务数量",   notes = "查询当前状态任务数量")
	@GetMapping(value = "/list/count")
	public ResponseModel<List<FailureStatusCountDto>> selectStatusCount(@RequestParam Integer type) {
		return ResponseHelper.buildResponse(failureDetailsServiceImpl.queryStatusCount(type));
	}


	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "流程信息",   notes = "流程信息")
	@GetMapping(value = "/processHistory")
	public ResponseModel<Object> selectHistoryt(@RequestParam Long sequenceNbr) {
		return ResponseHelper.buildResponse(failureDetailsServiceImpl.getCurrentProcessHistoryTask(sequenceNbr));
	}
	
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "权限button的显示",   notes = "权限button的显示")
	@GetMapping(value = "/getExcuteTaskAuthButton/{sequenceNbr}")
	public ResponseModel<Integer> getExcuteTaskAuthButton(@PathVariable Long sequenceNbr) {
		return ResponseHelper.buildResponse(failureDetailsServiceImpl.getExcuteTaskAuthButton(sequenceNbr, getSelectedOrgInfo()));
		
	}
}
