package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.common.api.dto.FailureAuditDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureDetailsDto;
import com.yeejoin.amos.boot.module.common.api.dto.FailureRepairlogDto;
import com.yeejoin.amos.boot.module.common.api.entity.FailureAudit;
import com.yeejoin.amos.boot.module.common.api.enums.AuditResultEnum;
import com.yeejoin.amos.boot.module.common.api.enums.FailureStatuEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.FailureAuditMapper;
import com.yeejoin.amos.boot.module.common.api.service.IFailureAuditService;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-08-04
 */
@Service
public class FailureAuditServiceImpl extends BaseService<FailureAuditDto, FailureAudit, FailureAuditMapper>
        implements IFailureAuditService {
    @Autowired
    FailureDetailsServiceImpl failureDetailsService;

    @Autowired
    FailureRepairlogServiceImpl failureRepairlogService;

    /**
     * 分页查询
     */
    public Page<FailureAuditDto> queryForFailureAuditPage(Page<FailureAuditDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<FailureAuditDto> queryForFailureAuditList() {
        return this.queryForList("", false);
    }

    /**
     * 发起审核
     */
    @Transactional
    public FailureAuditDto savemodel(FailureAuditDto model, ReginParams userInfo) throws Exception {

      /*  if (model.getAuditResult().equals(5)) {
            model.setAuditTime(new Date());
            model.setIsDelete(false);
            this.createWithModel(model);
            return model;
        }*/

        Integer auditResult = model.getAuditResult();
        //根据审核的结果进行业务操作
        if (auditResult.equals(AuditResultEnum.AGREE.getCode())) {
            updateStatus(model, FailureStatuEnum.WAITING_MAINTAIN, userInfo);
        } else if (auditResult.equals(AuditResultEnum.REFUSE.getCode())) {
            updateStatus(model, FailureStatuEnum.REFUSE, userInfo);
        } else if (auditResult.equals(AuditResultEnum.SEND_BACK.getCode())) {
            updateStatus(model, FailureStatuEnum.WAITING_SUBMIT, userInfo);
        }
        return model;
    }

    /**
     * 修改故障保修单任务状态
     */
    @Transactional
    FailureDetailsDto updateStatus(FailureAuditDto model, FailureStatuEnum status, ReginParams userInfo) throws Exception {

        failureDetailsService.checkExcuteTaskAuthMap(model.getSequenceNbr(),userInfo);


        FailureDetailsDto failureDetailsDto = failureDetailsService.queryBySeq(model.getFaultId());
        failureDetailsDto.setCurrentStatus(status.getCode());
        failureDetailsDto.setSequenceNbr(model.getFaultId());
        String condition;

        //添加报修日志
        Long faultId = model.getFaultId();
        Date processTime = model.getAuditTime();
        String processDepartment = model.getAuditDepartment();
        String processAuditor = model.getAuditor();
        if (status.equals(AuditResultEnum.AGREE)) {
            condition = AuditResultEnum.AGREE.getName();
            repairlog(faultId,processAuditor,processTime,processDepartment,condition);
        }
        if (status.equals(AuditResultEnum.SEND_BACK)) {
            condition = AuditResultEnum.SEND_BACK.getName();
            repairlog(faultId,processAuditor,processTime,processDepartment,condition);
        }
        condition = AuditResultEnum.REFUSE.getName();

        failureDetailsService.excuteTask(failureDetailsDto.getProcessId(), userInfo, condition);

        repairlog(faultId,processAuditor,processTime,processDepartment,condition);
        return failureDetailsService.updateWithModel(failureDetailsDto);
    }

    /**
     * 添加报修日志
     */
    @Transactional
    public void repairlog(Long faultId, String processAuditor, Date processTime, String processDepartment, String processResult) {
        FailureRepairlogDto failureRepairlogDto = new FailureRepairlogDto();
        failureRepairlogDto.setFaultId(faultId);
        failureRepairlogDto.setProcessAuditor(processAuditor);
        failureRepairlogDto.setProcessTime(processTime);
        failureRepairlogDto.setProcessDepartment(processDepartment);
        failureRepairlogDto.setProcessResult(processResult);
        failureRepairlogService.createWithModel(failureRepairlogDto);
    }

    /**
     * 根据FaultId查询
     */
    public List<FailureAudit> findByfaultId(Long faultId) {
        Page<FailureAudit> page = new Page<>();
        QueryWrapper<FailureAudit> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fault_id", faultId).orderByDesc("submission_time");
        return baseMapper.selectList(queryWrapper);
    }

    public FailureAudit findByFaultId(Long faultId) {
        LambdaQueryWrapper<FailureAudit> wrapper = new LambdaQueryWrapper<FailureAudit>();
        wrapper.eq(FailureAudit::getIsDelete, false);
        wrapper.eq(FailureAudit::getFaultId, faultId);
        wrapper.orderByAsc(FailureAudit::getAuditTime);
        wrapper.last("LIMIT 1");
        return this.baseMapper.selectOne(wrapper);
    }

}