package com.yeejoin.amos.boot.module.hygf.api.Enum;


import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 节点信息
 * @author DELL
 */
@Getter
@AllArgsConstructor
public enum PowerStationNodeEnum {


    经销商审核("经销商确认", "hygf_02"),
    设计审核("设计审核", "hygf_03"),
    投融审核("投融审核", "hygf_05"),
    法务审核("法务审核", "hygf_07"),
    设计上传图纸("设计上传图纸", "hygf_09"),
    经销商上传图纸("经销商上传图纸", "hygf_10"),
    文件审核("文件审核", "hygf_11");


    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private String code;

    public static PowerStationNodeEnum getNodeByCode(String code) {
        PowerStationNodeEnum powerStationNodeEnum = null;
        for(PowerStationNodeEnum type: PowerStationNodeEnum.values()) {
            if (type.getCode().equals(code)) {
                powerStationNodeEnum = type;
                break;
            }
        }
        return powerStationNodeEnum;
    }
}
