package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpCollector;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpInverter;
import com.yeejoin.amos.boot.module.hygf.api.entity.JpPersonStation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 第三方场站
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JpStationDto", description = "第三方场站")
public class JpStationDto extends BaseDto {
    @ExcelIgnore
	private static final long serialVersionUID = 1L;
    @ExcelIgnore
	@ApiModelProperty(value = "sn编码")
	private String snCode;
    @ExcelIgnore
	@ApiModelProperty(value = "装机容量")
	private Double capacity;
    @ExcelProperty(value = "电站名称", index = 1)
	@ApiModelProperty(value = "电站名称")
	private String name;
    @ExcelProperty(value = "电站编号", index = 0)
	@ApiModelProperty(value = "电站编码")
	private String code;
    @ExcelIgnore
	@ApiModelProperty(value = "组织编码")
	private String systemCode;
    @ExcelIgnore
	@ApiModelProperty(value = "接入平台时间")
	private Date accessTime;
    @ExcelIgnore
	@ApiModelProperty(value = "创建时间")
	private Date createTime;
    @ExcelIgnore
	@ApiModelProperty(value = "地址")
	private String address;
    @ExcelIgnore
	@ApiModelProperty(value = "经度")
	private String longitude;
    @ExcelIgnore
	@ApiModelProperty(value = "维度")
	private String latitude;
    @ExcelIgnore
	@ApiModelProperty(value = "上网电价")
	private Double price;
    @ExcelProperty(value = "业主姓名", index = 3)
	@ApiModelProperty(value = "业主姓名")
	private String userName;
    @ExcelIgnore
	@ApiModelProperty(value = "业主电话")
	private String userPhone;
    @ExcelProperty(value = "电站联系人", index = 4)
	@ApiModelProperty(value = "电站联系人")
	private String stationContact;
    @ExcelIgnore
	@ApiModelProperty(value = "组件数量")
	private Integer moduleCount;
    @ExcelIgnore
	@ApiModelProperty(value = "并网类型")
	private String onGridType;
    @ExcelIgnore
	@ApiModelProperty(value = "并网时间")
	private Date onGridTime;
    @ExcelIgnore
	@ApiModelProperty(value = "第三方电站id")
	private String thirdStationId;
    @ExcelIgnore
	@ApiModelProperty(value = "电站id")
	private Long stationId;
    @ExcelIgnore
	@ApiModelProperty(value = "第三方厂商标识")
	private String thirdCode;
	/**
	 * 实时功率
	 */
    @ExcelIgnore
	private Double realTimePower;
	/**
	 * 累计发电量
	 */
    @ExcelProperty(value = "累计发电量（mWh）", index = 6)
	private Double accumulatedPower;
    @ExcelIgnore
	/**
	 * 状态
	 */
	private String state;
	/**
	 * 电站类型
	 */
    @ExcelIgnore
	private String type;
	/**
	 * 组织编码
	 */
    @ExcelIgnore
	private String organizationalCode;
    @ExcelIgnore
	// 日发电量
	private Double dayGenerate;
    @ExcelIgnore
	// 月发电量
	private Double monthGenerate;
    @ExcelIgnore
	// 年发电量
	private Double yearGenerate;
	// 日收益
    @ExcelIgnore
	private Double dayIncome;
    @ExcelIgnore
	// 月收益
	private Double monthIncome;
    @ExcelIgnore
	// 年收益
	private Double yearIncome;
	// 地区
    @ExcelIgnore
	private String area;
    @ExcelIgnore
	List<JpPersonStation> statioId;
    @ExcelProperty(value = "累计收益（元）", index = 7)
	// 累计收益
	private Double cumulativeIncome;
    @ExcelIgnore
	private Double dayPowerUse; // 日用电量
    @ExcelIgnore
	private Double monthPowerUse; // 月用电量
    @ExcelIgnore
	private Double yearPowerUse; // 年用电量
    @ExcelIgnore
	private int countBuiltNum;// 已建设场站数量
    @ExcelIgnore
	private int countNBuiltNum;// 未建设场站数量
    @ExcelIgnore
	List<JpInverter> jpInverter;
    @ExcelIgnore
	List<JpCollector> JpCollector;
	// 时间
    @ExcelIgnore
	String dateType;
    @ExcelIgnore
	private String email;
    @ExcelIgnore
    private Double ratedPower;
    @ExcelIgnore
    private String regionalCompaniesCode;
    @ExcelIgnore
    private String regionalCompaniesName;

    @ExcelIgnore
    private String amosCompanyCode;

    //场站id
    @ExcelIgnore
    private List<String> thirdStationIds;
    @ExcelProperty(value = "时间", index = 2)
    String timeDate;
    /**
     * 满发小时数
     *
     * */
    @ExcelProperty(value = "满发小时数（h）", index = 5)
    private Double fullhour;


    /**
     *
     * 实时功率比/
     * **/
    @ExcelIgnore
    List<Map<String,Object>> powerRatio;


    @ExcelIgnore
    String timeDateMonth;
    @ExcelIgnore
    String timeDateYear;


    @ExcelIgnore
    String nbsn;
    @ExcelIgnore
    String cjsn;
    @ExcelIgnore
    String dbsn;
    @ExcelIgnore
    String qxysn;
}
