package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 人员合同信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person_contract")
@ApiModel(value = "PersonContract对象", description = "人员合同信息")
public class PersonContract extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;

    @ApiModelProperty(value = "劳动合同类型key(0-合同制、1-劳务派遣、2-临时协议、3-其他)")
    private String contractTypeKey;
    @TableField(exist = false)
    private String contractTypeKeyLabel;

    @ApiModelProperty(value = "劳动合同名称")
    private String contractName;
    @ApiModelProperty(value = "劳动合同主体单位id")
    private Long contractCompanyId;
    @ApiModelProperty(value = "劳动合同主体单位名称")
    @TableField(exist = false)
    private String contractCompanyName;
    
    @ApiModelProperty(value = "合同期限key(0-有固定期限、1-无固定期限、2-以任务为限、3-其他)")
    private String expiryTypeKey;
    @TableField(exist = false)
    private String expiryTypeKeyLabel;

    @ApiModelProperty(value = "合同开始时间")
    private Date startTime;
    @ApiModelProperty(value = "合同结束时间")
    private Date endTime;
    @ApiModelProperty(value = "是否生效(0-生效 1-作废)")
    private Integer useful;
    @ApiModelProperty(value = "离职时间")
    private Date departureTime;
    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    @ImagePrefix
    private List<PersonContractAttachment> attachment;
}
