package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_person_message")
@ApiModel(value = "PersonMessage对象", description = "")
public class PersonMessage extends BaseEntity {
	private static final long serialVersionUID = 1L;
	@ApiModelProperty(value = "人员信息id")
	private Long personId;
	@ApiModelProperty(value = "消息类型")
	private Integer type;
	@ApiModelProperty(value = "子类型")
	private Long subType;
	@ApiModelProperty(value = "所在项目id")
	private Long projectId;
	@ApiModelProperty(value = "任务id")
	private Long taskId;
	@ApiModelProperty(value = "消息内容")
	private String content;
	@ApiModelProperty(value = "阅读状态  0未读 1已读")
	private int readStatus;
	@ApiModelProperty(value = "对象id")
	private Long objectId;
	@ApiModelProperty(value = "消息名称")
	@TableField(exist = false)
	private String typeName;
	@ApiModelProperty(value = "项目名称")
	@TableField(exist = false)
	private String projectName;

	/**
	 * 子类型名称
	 */
	@TableField(exist = false)
	private String subTypeName;
	/**
	 * 头像
	 */
	@ImagePrefix
	@TableField(exist = false)
	private String profile;

	/**
	 * 状态
	 */
	@TableField(exist = false)
	private Integer status;

	/**
	 * 扩展参数
	 */
	@ApiModelProperty(value = "扩展参数")
	private String param;

	private Long taskPersonId;
}
