package com.yeejoin.amos.boot.module.ugp.biz.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yeejoin.amos.boot.module.ugp.api.Enum.ProcessTypeEnum;
import com.yeejoin.amos.boot.module.ugp.api.Enum.WhetherItPassEnum;
import com.yeejoin.amos.boot.module.ugp.api.dto.OverProjectDto;
import com.yeejoin.amos.boot.module.ugp.api.entity.Project;
import com.yeejoin.amos.boot.module.ugp.api.entity.ProjectInitiation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProjectOverFlowServiceImpl {

    @Autowired
    ProjectServiceImpl projectServiceImpl;

    @Autowired
    ProjectInitiationServiceImpl projectInitiationServiceImpl;

    public OverProjectDto selectOne(Long sequenceNbr){
        Project project = projectServiceImpl.getById(sequenceNbr);
        LambdaQueryWrapper<ProjectInitiation> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ProjectInitiation::getInstanceId, project.getInstanceId());
        wrapper.eq(ProjectInitiation::getType, ProcessTypeEnum.项目结项.getType());
        wrapper.orderByDesc(ProjectInitiation::getRecDate);
        wrapper.last(" limit 1");
        ProjectInitiation one = projectInitiationServiceImpl.getOne(wrapper);
        if (com.baomidou.mybatisplus.core.toolkit.ObjectUtils.isNotEmpty(one) && StringUtils.isNotEmpty(one.getContext())) {
            OverProjectDto overProjectDto = JSON.parseObject(one.getContext(), OverProjectDto.class);
            if ((StringUtils.isNotEmpty(overProjectDto.getAuditOpinion()) && WhetherItPassEnum.REJECT.getCode().equals(overProjectDto.getCondition())) ||
                    (StringUtils.isNotEmpty(overProjectDto.getIsAgree()) && WhetherItPassEnum.REJECT.getCode().equals(overProjectDto.getIsAgree()))) {
                return new OverProjectDto();
            }
            return overProjectDto;
        }
        return new OverProjectDto();
    }
}
