package com.yeejoin.amos.api.openapi.face.model;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;


@EqualsAndHashCode(callSuper = true)
@Data
public class TmCylinderFillingRecordModel extends CylinderAbstractBaseModel {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "充装枪编号")
	private String gunNumber;

	@ApiModelProperty(value = "充装开始时间")
	@TableField("filling_start_time")
	private Date fillingStartTime;

	@ApiModelProperty(value = "充装结束时间")
	@TableField("filling_end_time")
	private Date fillingEndTime;

	@ApiModelProperty(value = "充装量m3/（kg）")
	private Double fillingAmount;

	@ApiModelProperty(value = "压力")
	private Double pressure;

	@ApiModelProperty(value = "室温")
	private Double ambientTemperature;

	@ApiModelProperty(value = "异常情况")
	private String abnormalConditions;

	@ApiModelProperty(value = "瓶体温度无异常升高")
	private String isNoAbnormalTemperatureRise;

	@ApiModelProperty(value = "充装压力")
	private Double fillingPressure;

	@ApiModelProperty(value = "瓶体温度一致")
	private String temperatureConsistent;

	@ApiModelProperty(value = "瓶内无异常音响")
	private String noAbnormalSoundInside;

	@ApiModelProperty(value = "瓶阀及各连接部位的密封良好")
	private String valveSealedWell;

	@ApiModelProperty(value = "充装压力≤2.5 MPa")
	private String fillingPressureLessThan;

	@ApiModelProperty(value = "乙炔充装量")
	private Double acetyleneFillingAmount;

	@ApiModelProperty(value = "各组分含量")
	private Double componentContents;

	@ApiModelProperty(value = "标称皮重")
	private Double tareWeightNominal;

	@ApiModelProperty(value = "充装后质量")
	private Double filledWeight;

	@ApiModelProperty(value = "实际充装量")
	private Double actualFillingAmount;

	@ApiModelProperty(value = "含余气皮重")
	private Double tareWeightIncludingResidualGas;
}
