package com.yeejoin.amos.boot.module.common.api.entity;

import java.util.Date;
import java.util.Objects;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 值班人员日期关联关系表
 *
 * @author system_generator
 * @date 2021-07-06
 */
@Data
@Accessors(chain = true)
@TableName("cb_duty_person_shift")
public class DutyPersonShift extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
     * 值班日期
     */
    @TableField("duty_date")
    private Date dutyDate;
    /**
     * 值班班次id
     */
    @TableField("shift_id")
    private Long shiftId;
    /**
     * 实例id
     */
    @TableField("instance_id")
    private Long instanceId;

    /**
     * 应用标识（数据隔离使用）
     */
    private String appKey;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DutyPersonShift)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DutyPersonShift that = (DutyPersonShift) o;
        return Objects.equals(dutyDate, that.dutyDate) &&
                Objects.equals(instanceId, that.instanceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), dutyDate, instanceId);
    }
}
