package com.yeejoin.amos.boot.module.jyjc.biz.typeHandler;

import com.yeejoin.amos.boot.biz.common.entity.DataDictionary;
import com.yeejoin.amos.boot.biz.common.service.impl.DataDictionaryServiceImpl;
import com.yeejoin.amos.boot.biz.common.typeHandler.TypeHandler;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 特种设备目录处理器
 */
@RequiredArgsConstructor
@Component
public class InspectTypeHandler implements TypeHandler<String> {
    private final Map<String, String> CODE_NAME_MAP = new ConcurrentHashMap<>();

    private final DataDictionaryServiceImpl dataDictionaryService;

    @Override
    public String handle(String code) {
        return StringUtils.isNotEmpty(code) ? CODE_NAME_MAP.computeIfAbsent(code, (k) -> {
            DataDictionary dictionary = dataDictionaryService.getByCode(k, "JYJC");
            return dictionary != null ? dictionary.getName() : "";
        }) : null;
    }
}
