package com.yeejoin.amos.boot.module.jcs.api.service;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * @Author: xinglei
 * @Description:
 * @Date: 2021/11/25 10:18
 */
public interface IFusionService {

    /**
     * 查询所有在线成员信息
     * @return
     */
    JSONObject getAllOnlineUser();

    /**
     * 获取用户详细信息
     * @param employeeID 设备号码
     * @return
     */
    JSONObject getEmployeeByEID(String employeeID);

    /**
     * 获取设备的最后一次位置信息
     * @param employeeID 设备号码
     * @return
     */
    Map<String, String> getGISByEmployeeID(String employeeID);

    /**
     * 获取最新的一条通话记录
     * @param caller 主呼号码
     * @param called 被呼号码
     * @return
     */
    Map<String, String> getCallRecordByNumber(String caller, String called);

    /**
     * 获取通话录音记录
     * @param cid 呼叫ID
     * @return
     */
    Map<String, String> getCallRecordByCID(String cid);
}
