package com.yeejoin.amos.boot.module.tzs.flc.biz.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.biz.service.impl.SourceFileServiceImpl;
import com.yeejoin.amos.boot.module.tzs.flc.api.dto.EquipmentDto;
import com.yeejoin.amos.boot.module.tzs.flc.api.entity.Equipment;
import com.yeejoin.amos.boot.module.tzs.flc.api.enums.EquipmentStatusEnum;
import com.yeejoin.amos.boot.module.tzs.flc.api.mapper.EquipmentMapper;
import com.yeejoin.amos.boot.module.tzs.flc.api.service.IEquipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.UUID;

/**
 * 装备信息表服务实现类
 *
 * @author system_generator
 * @date 2021-11-25
 */
@Service
public class EquipmentServiceImpl extends BaseService<EquipmentDto, Equipment, EquipmentMapper> implements IEquipmentService {

    @Autowired
    SourceFileServiceImpl sourceFileService;

    /**
     * 分页查询
     */
    public Page<EquipmentDto> queryForEquipmentPage(Page<EquipmentDto> page) {
        return this.queryForPage(page, null, false);
    }

    /**
     * 列表查询 示例
     */
    public List<EquipmentDto> queryForEquipmentList() {
        return this.queryForList("", false);
    }

    @Override
    public EquipmentDto createEquipment(EquipmentDto model) {
        UUID uuid = UUID.randomUUID();
        model.setEquipId(uuid.toString());
        model = this.createWithModel(model);
        saveSourceFile(model);
        return model;
    }

    @Override
    public EquipmentDto updateEquipment(EquipmentDto model) {
        this.updateWithModel(model);
        saveSourceFile(model);
        Bean.copyExistPropertis(this.queryBySeq(model.getSequenceNbr()), model);
        return model;
    }

    @Override
    public Boolean deleteById(Long sequenceNbr) {
        EquipmentDto equipmentDto = this.queryBySeq(sequenceNbr);
        // 未安装设备可删除
        if (!ValidationUtil.isEmpty(equipmentDto) && EquipmentStatusEnum.未安装.getCode().equals(equipmentDto.getStatus())) {
            equipmentDto.setIsDelete(true);
            this.updateWithModel(equipmentDto);
            return true;
        }
        return false;
    }

    // 保存附件信息
    public void saveSourceFile(EquipmentDto model) {
        if (model.getAttachments() != null) {
            sourceFileService.saveAttachments(model.getSequenceNbr(), model.getAttachments());
        }
    }
}