package com.yeejoin.amos.api.openapi.face.service;

import com.yeejoin.amos.api.openapi.face.model.StaffBaseInfoModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.StaffBaseInfoMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.StaffBaseInfo;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * 人员数据信息-基本信息 服务类
 *
 * @author duanwei
 * @date 2022-07-19
 */
@Component
public class StaffBaseInfoService extends AppBaseService<StaffBaseInfoModel, StaffBaseInfo, StaffBaseInfoMapper> {

    /**
     *
     * 新增人员基本信息
     *
     * @param model 人员基本信息实体类集合
     * @return 成功返回“OK”
     */
    @Transactional(rollbackFor= {Exception.class})
    public String saveStaffBaseInfo(List<StaffBaseInfo> model) {
        // TODO Auto-generated method stub
        if (ValidationUtil.isEmpty(model)) {
            throw new BadRequest("人员基本信息为空.");
        }

        for (StaffBaseInfo models : model) {
//            checkModel(models);
            models.setRecDate(new Date());
            models.setAppId(getAppId());
        }
        this.saveBatch(model);
        return "OK";
    }

    /**
     * 信息校验
     *
     * @param models
     */
//    private static void checkModel(StaffBaseInfo models) {
//        if(ValidationUtil.isEmpty(models.getOperatorId())) {
//            throw new BadRequest("作业人员身份证号不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOperator())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"作业人员姓名不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUnitCode())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"工作单位代码不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getUnit())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"工作单位名称不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getOperatorIdType())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"作业人员证件类型不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getPhone())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"联系电话不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getEmploymentDate())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"聘用时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncDate())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"同步时间不能为空！");
//        }
//        if(ValidationUtil.isEmpty(models.getSyncState())) {
//            throw new BadRequest("作业人员身份证号为："+models.getOperatorId()+"的人员，"+"同步状态不能为空！");
//        }
//    }
}
