package com.yeejoin.equipmanage.common.vo;



public class QREquipResponse extends ScanResult<QREquipResponse>{
	
	/**
	 * 车辆， 装备
	 */
	private String type;
	
	/**
	 * 扫描的装备基本信息
	 */
	private ScanEquipmentBasicInfo equipment;
	
	/**
	 * 扫描的车辆基本信息
	 */
	private ScanCarBasicInfo car;
	
	/**
	 * 货位信息
	 */
	private ScanShelfCellBasicInfo shelfCell;
	
	/**
	 * 装备附加信息
	 */
	private ScanEquipEdditionalInfo equipEdditionalInfo;
	
	/**
	 * 是否需要附加信息
	 */
	private boolean needEdditionalInfo = false;
	
	@Override
	public QREquipResponse get() {
		return this;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public ScanEquipmentBasicInfo getEquipment() {
		return equipment;
	}

	public void setEquipment(ScanEquipmentBasicInfo equipment) {
		this.equipment = equipment;
	}

	public ScanCarBasicInfo getCar() {
		return car;
	}

	public void setCar(ScanCarBasicInfo car) {
		this.car = car;
	}

	public ScanShelfCellBasicInfo getShelfCell() {
		return shelfCell;
	}

	public void setShelfCell(ScanShelfCellBasicInfo shelfCell) {
		this.shelfCell = shelfCell;
	}

	public boolean isNeedEdditionalInfo() {
		return needEdditionalInfo;
	}

	public void setNeedEdditionalInfo(boolean needEdditionalInfo) {
		this.needEdditionalInfo = needEdditionalInfo;
	}
	
	public ScanEquipEdditionalInfo getEquipEdditionalInfo() {
		return equipEdditionalInfo;
	}

	public void setEquipEdditionalInfo(ScanEquipEdditionalInfo equipEdditionalInfo) {
		this.equipEdditionalInfo = equipEdditionalInfo;
	}

	/**
	 * 将装备附加信息合并到装备基本信息中
	 */
	public void merge() {
		if (isNeedEdditionalInfo()) {			
			setEquipment(getEquipEdditionalInfo().merge(getEquipment()));
		} 
		setEquipEdditionalInfo(null);
	}
}

